/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.SmppSessionListener;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSmppSessionHandler
implements SmppSessionListener {
    private final Logger logger;

    public DefaultSmppSessionHandler() {
        this(LoggerFactory.getLogger(DefaultSmppSessionHandler.class));
    }

    public DefaultSmppSessionHandler(Logger logger) {
        this.logger = logger;
    }

    public String lookupResultMessage(int commandStatus) {
        return null;
    }

    public String lookupTlvTagName(short tag) {
        return null;
    }

    public void fireChannelUnexpectedlyClosed() {
        this.logger.info("Default handling is to discard an unexpected channel closed");
    }

    public PduResponse firePduRequestReceived(PduRequest pduRequest) {
        this.logger.warn("Default handling is to discard unexpected request PDU: {}", (Object)pduRequest);
        return null;
    }

    public void fireExpectedPduResponseReceived(PduAsyncResponse pduAsyncResponse) {
        this.logger.warn("Default handling is to discard expected response PDU: {}", (Object)pduAsyncResponse);
    }

    public void fireUnexpectedPduResponseReceived(PduResponse pduResponse) {
        this.logger.warn("Default handling is to discard unexpected response PDU: {}", (Object)pduResponse);
    }

    public void fireUnrecoverablePduException(UnrecoverablePduException e) {
        this.logger.warn("Default handling is to discard a unrecoverable exception:", (Throwable)e);
    }

    public void fireRecoverablePduException(RecoverablePduException e) {
        this.logger.warn("Default handling is to discard a recoverable exception:", (Throwable)e);
    }

    public void fireUnknownThrowable(Throwable t) {
        if (t instanceof ClosedChannelException) {
            this.logger.warn("Unknown throwable received, but it was a ClosedChannelException, calling fireChannelUnexpectedlyClosed instead");
            this.fireChannelUnexpectedlyClosed();
        } else {
            this.logger.warn("Default handling is to discard an unknown throwable:", t);
        }
    }

    public void firePduRequestExpired(PduRequest pduRequest) {
        this.logger.warn("Default handling is to discard expired request PDU: {}", (Object)pduRequest);
    }

    public boolean firePduReceived(Pdu pdu) {
        return true;
    }

    public boolean firePduDispatch(Pdu pdu) {
        return true;
    }
}

