/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.pdu;

import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.ChannelBufferUtil;
import com.cloudhopper.smpp.util.PduUtil;
import org.jboss.netty.buffer.ChannelBuffer;

public class AlertNotification
extends Pdu {
    protected Address sourceAddress;
    protected Address esmeAddress;

    public AlertNotification() {
        super(258, "alert_notification", true);
    }

    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Address value) {
        this.sourceAddress = value;
    }

    public Address getEsmeAddress() {
        return this.esmeAddress;
    }

    public void setEsmeAddress(Address value) {
        this.esmeAddress = value;
    }

    protected int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.sourceAddress);
        return bodyLength += PduUtil.calculateByteSizeOfAddress(this.esmeAddress);
    }

    public void readBody(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.sourceAddress = ChannelBufferUtil.readAddress(buffer);
        this.esmeAddress = ChannelBufferUtil.readAddress(buffer);
    }

    public void writeBody(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        ChannelBufferUtil.writeAddress(buffer, this.sourceAddress);
        ChannelBufferUtil.writeAddress(buffer, this.esmeAddress);
    }

    protected void appendBodyToString(StringBuilder buffer) {
        buffer.append("( sourceAddr [");
        buffer.append(StringUtil.toStringWithNullAsEmpty((Object)this.sourceAddress));
        buffer.append("] esmeAddr [");
        buffer.append(StringUtil.toStringWithNullAsEmpty((Object)this.esmeAddress));
        buffer.append("])");
    }
}

