/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.pdu;

import com.cloudhopper.smpp.pdu.BaseSm;
import com.cloudhopper.smpp.pdu.SubmitMultiResp;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppInvalidArgumentException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.ChannelBufferUtil;
import com.cloudhopper.smpp.util.PduUtil;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitMulti
extends BaseSm<SubmitMultiResp> {
    private int numberOfDest;
    private List<Address> destAddresses = new ArrayList<Address>();
    private List<String> destDistributionList = new ArrayList<String>();

    public SubmitMulti() {
        super(33, "submit_multi");
    }

    @Override
    public SubmitMultiResp createResponse() {
        SubmitMultiResp resp = new SubmitMultiResp();
        resp.setSequenceNumber(this.getSequenceNumber());
        return resp;
    }

    @Override
    public Class<SubmitMultiResp> getResponseClass() {
        return SubmitMultiResp.class;
    }

    @Override
    public Address getDestAddress() {
        return null;
    }

    @Override
    public void setDestAddress(Address value) {
    }

    public void addDestAddresses(Address address) throws SmppInvalidArgumentException {
        ++this.numberOfDest;
        this.destAddresses.add(address);
    }

    public void addDestDestributionListName(String name) {
        ++this.numberOfDest;
        this.destDistributionList.add(name);
    }

    public List<Address> getDestAddresses() {
        return this.destAddresses;
    }

    public List<String> getDestDestributionListName() {
        return this.destDistributionList;
    }

    public int getNumberOfDest() {
        return this.numberOfDest;
    }

    @Override
    public void readBody(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.serviceType = ChannelBufferUtil.readNullTerminatedString(buffer);
        this.sourceAddress = ChannelBufferUtil.readAddress(buffer);
        this.numberOfDest = buffer.readByte() & 0xFF;
        for (int count = 0; count < this.numberOfDest; ++count) {
            byte flag = buffer.readByte();
            if (flag == 1) {
                this.destAddresses.add(ChannelBufferUtil.readAddress(buffer));
                continue;
            }
            if (flag != 2) continue;
            this.destDistributionList.add(ChannelBufferUtil.readNullTerminatedString(buffer));
        }
        this.esmClass = buffer.readByte();
        this.protocolId = buffer.readByte();
        this.priority = buffer.readByte();
        this.scheduleDeliveryTime = ChannelBufferUtil.readNullTerminatedString(buffer);
        this.validityPeriod = ChannelBufferUtil.readNullTerminatedString(buffer);
        this.registeredDelivery = buffer.readByte();
        this.replaceIfPresent = buffer.readByte();
        this.dataCoding = buffer.readByte();
        this.defaultMsgId = buffer.readByte();
        short shortMessageLength = buffer.readUnsignedByte();
        this.shortMessage = new byte[shortMessageLength];
        buffer.readBytes(this.shortMessage);
    }

    @Override
    public void writeBody(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        ChannelBufferUtil.writeNullTerminatedString(buffer, this.serviceType);
        ChannelBufferUtil.writeAddress(buffer, this.sourceAddress);
        buffer.writeByte(this.numberOfDest);
        for (Address adress : this.destAddresses) {
            buffer.writeByte(1);
            ChannelBufferUtil.writeAddress(buffer, adress);
        }
        for (String s : this.destDistributionList) {
            buffer.writeByte(2);
            ChannelBufferUtil.writeNullTerminatedString(buffer, s);
        }
        buffer.writeByte((int)this.esmClass);
        buffer.writeByte((int)this.protocolId);
        buffer.writeByte((int)this.priority);
        ChannelBufferUtil.writeNullTerminatedString(buffer, this.scheduleDeliveryTime);
        ChannelBufferUtil.writeNullTerminatedString(buffer, this.validityPeriod);
        buffer.writeByte((int)this.registeredDelivery);
        buffer.writeByte((int)this.replaceIfPresent);
        buffer.writeByte((int)this.dataCoding);
        buffer.writeByte((int)this.defaultMsgId);
        buffer.writeByte((int)((byte)this.getShortMessageLength()));
        if (this.shortMessage != null) {
            buffer.writeBytes(this.shortMessage);
        }
    }

    @Override
    public int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.serviceType);
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.sourceAddress);
        ++bodyLength;
        for (Address adress : this.destAddresses) {
            ++bodyLength;
            bodyLength += PduUtil.calculateByteSizeOfAddress(adress);
        }
        for (String s : this.destDistributionList) {
            ++bodyLength;
            bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(s);
        }
        bodyLength += 3;
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.scheduleDeliveryTime);
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.validityPeriod);
        bodyLength += 5;
        return bodyLength += this.getShortMessageLength();
    }
}

