/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.type;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.ChannelBufferUtil;
import com.cloudhopper.smpp.util.PduUtil;
import org.jboss.netty.buffer.ChannelBuffer;

public class Address {
    private byte ton;
    private byte npi;
    private String address;

    public Address() {
        this(0, 0, null);
    }

    public Address(byte ton, byte npi, String address) {
        this.ton = ton;
        this.npi = npi;
        this.address = address;
    }

    public byte getTon() {
        return this.ton;
    }

    public void setTon(byte value) {
        this.ton = value;
    }

    public byte getNpi() {
        return this.npi;
    }

    public void setNpi(byte value) {
        this.npi = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        this.address = value;
    }

    public int calculateByteSize() {
        return 2 + PduUtil.calculateByteSizeOfNullTerminatedString(this.address);
    }

    public void read(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.ton = buffer.readByte();
        this.npi = buffer.readByte();
        this.address = ChannelBufferUtil.readNullTerminatedString(buffer);
    }

    public void write(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        buffer.writeByte((int)this.ton);
        buffer.writeByte((int)this.npi);
        ChannelBufferUtil.writeNullTerminatedString(buffer, this.address);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append("0x");
        buffer.append(HexUtil.toHexString((byte)this.ton));
        buffer.append(" 0x");
        buffer.append(HexUtil.toHexString((byte)this.npi));
        buffer.append(" [");
        buffer.append(StringUtil.toStringWithNullAsEmpty((Object)this.address));
        buffer.append("]");
        return buffer.toString();
    }
}

