/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.type;

import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.ChannelBufferUtil;
import org.jboss.netty.buffer.ChannelBuffer;

public class UnsucessfulSME {
    private int errorStatusCode;
    private Address address;

    public UnsucessfulSME() {
    }

    public UnsucessfulSME(int errorStatusCode, Address address) {
        this.errorStatusCode = errorStatusCode;
        this.address = address;
    }

    public int getErrorStatusCode() {
        return this.errorStatusCode;
    }

    public void setErrorStatusCode(int errorStatusCode) {
        this.errorStatusCode = errorStatusCode;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void read(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.address = ChannelBufferUtil.readAddress(buffer);
        this.errorStatusCode = buffer.readInt();
    }

    public void write(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        ChannelBufferUtil.writeAddress(buffer, this.address);
        buffer.writeInt(this.errorStatusCode);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(44);
        buffer.append(this.address.toString());
        buffer.append(" errorStatusCode [");
        buffer.append(this.errorStatusCode);
        buffer.append("]");
        return buffer.toString();
    }
}

