/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.resteasy.Failure;
import org.resteasy.InjectorFactoryImpl;
import org.resteasy.PathParamIndex;
import org.resteasy.ValueInjector;
import org.resteasy.specimpl.ResponseImpl;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.MethodInjector;
import org.resteasy.spi.ResteasyProviderFactory;

public class MethodInjectorImpl
implements MethodInjector {
    protected Method method;
    protected ValueInjector[] params;
    protected PathParamIndex index;

    public MethodInjectorImpl(Method method, PathParamIndex index, ResteasyProviderFactory factory) {
        this.method = method;
        this.index = index;
        this.params = new ValueInjector[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> type = method.getParameterTypes()[i];
            Type genericType = method.getGenericParameterTypes()[i];
            Annotation[] annotations = method.getParameterAnnotations()[i];
            this.params[i] = InjectorFactoryImpl.getParameterExtractor(index, type, genericType, annotations, method, factory);
        }
    }

    public Object[] injectArguments(HttpRequest input, HttpResponse response) {
        Object[] args = null;
        if (this.params != null && this.params.length > 0) {
            args = new Object[this.params.length];
            int i = 0;
            for (ValueInjector extractor : this.params) {
                args[i++] = extractor.inject(input, response);
            }
        }
        return args;
    }

    public Response invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure {
        Object[] args = null;
        try {
            args = this.injectArguments(request, httpResponse);
        }
        catch (Exception e) {
            throw new Failure("Failed processing arguments of " + this.method.toString(), e, 400);
        }
        try {
            Object rtn = this.method.invoke(resource, args);
            if (this.method.getReturnType().equals(Void.TYPE)) {
                return new ResponseImpl();
            }
            if (this.method.getReturnType().equals(Response.class)) {
                return (Response)rtn;
            }
            ResponseImpl response = new ResponseImpl();
            response.setEntity(rtn);
            response.setStatus(200);
            return response;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed processing of " + this.method.toString(), e);
        }
        catch (InvocationTargetException e) {
            WebApplicationException wae;
            Throwable cause = e.getCause();
            if (cause instanceof WebApplicationException && (wae = (WebApplicationException)cause).getResponse() != null) {
                cause.printStackTrace();
                return wae.getResponse();
            }
            throw new RuntimeException("Failed processing " + this.method.toString(), e.getCause());
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad arguments passed to " + this.method.toString() + "  (";
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg;
            }
            throw new RuntimeException(msg, e);
        }
    }
}

