/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.PathSegment;
import org.resteasy.Failure;
import org.resteasy.specimpl.UriInfoImpl;
import org.resteasy.spi.HttpRequest;
import org.resteasy.util.PathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathParamIndex {
    protected List<Segment> segments = new ArrayList<Segment>();
    protected String path;
    protected Map<String, List<Integer>> uriParams = new HashMap<String, List<Integer>>();
    protected int offset;
    protected boolean wildcard;

    public PathParamIndex(String path, int offset, boolean wildcard) {
        this.offset = offset;
        this.path = path;
        this.wildcard = wildcard;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] paths = path.split("/");
        int i = offset;
        for (String p : paths) {
            Segment segment = new Segment();
            this.segments.add(segment);
            Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(p);
            boolean found = false;
            while (matcher.find()) {
                found = true;
                String uriParamName = matcher.group(2);
                segment.pathParams.add(uriParamName);
                List<Integer> paramIndexes = this.uriParams.get(uriParamName);
                if (paramIndexes == null) {
                    paramIndexes = new ArrayList<Integer>();
                    this.uriParams.put(uriParamName, paramIndexes);
                }
                paramIndexes.add(i);
            }
            if (found) {
                segment.pattern = Pattern.compile(PathHelper.createRegularExpressionFromPathExpression(p));
            }
            ++i;
        }
    }

    public void populateUriInfoTemplateParams(HttpRequest input) {
        UriInfoImpl uriInfo = (UriInfoImpl)input.getUri();
        List pathSegments = input.getUri().getPathSegments(false);
        int i = this.offset;
        String lastName = null;
        String lastValue = null;
        int k = 0;
        while (i < this.segments.size() + this.offset && i < pathSegments.size()) {
            PathSegment pathSegment = (PathSegment)pathSegments.get(i);
            Segment segment = this.segments.get(k);
            if (segment.pattern == null) {
                lastValue = null;
                lastName = null;
            } else {
                Matcher matcher = segment.pattern.matcher(pathSegment.getPath());
                if (!matcher.matches()) {
                    throw new Failure("Path Segment does not match expression", 500);
                }
                int pathParamsIndex = 0;
                for (int g = 1; g <= matcher.groupCount(); ++g) {
                    String name = segment.pathParams.get(pathParamsIndex++);
                    String value = matcher.group(g);
                    uriInfo.addEncodedPathParameter(name, value);
                    lastName = name;
                    lastValue = value;
                }
            }
            ++i;
            ++k;
        }
        if (this.wildcard && lastName != null && i < pathSegments.size()) {
            while (this.wildcard && i < pathSegments.size()) {
                PathSegment pathSegment = (PathSegment)pathSegments.get(i);
                lastValue = lastValue + "/" + pathSegment.getPath();
                ++i;
            }
            List values = (List)uriInfo.getPathParameters(false).get(lastName);
            values.set(values.size() - 1, lastValue);
            values = (List)uriInfo.getPathParameters().get(lastName);
            try {
                values.set(values.size() - 1, URLDecoder.decode(lastValue, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, List<Integer>> getUriParams() {
        return this.uriParams;
    }

    public int getOffset() {
        return this.offset;
    }

    private static class Segment {
        Pattern pattern;
        List<String> pathParams = new ArrayList<String>();

        private Segment() {
        }
    }
}

