/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.mock;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.resteasy.mock.Assert;
import org.resteasy.mock.MockRequestDispatcher;

public class MockServletContext
implements ServletContext {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private final Object resourceLoader = null;
    private final String resourceBasePath;
    private final Properties initParameters = new Properties();
    private final Hashtable attributes = new Hashtable();
    private String servletContextName = "MockServletContext";

    public MockServletContext() {
        this("", null);
    }

    public MockServletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public MockServletContext(Object resourceLoader) {
        this("", resourceLoader);
    }

    public MockServletContext(String resourceBasePath, Object resourceLoader) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    public String getContextPath() {
        return this.resourceBasePath;
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public ServletContext getContext(String name) {
        throw new UnsupportedOperationException("getContext");
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String filePath) {
        throw new UnsupportedOperationException("getMimeType");
    }

    public Set getResourcePaths(String path) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public URL getResource(String path) throws MalformedURLException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public InputStream getResourceAsStream(String path) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new MockRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return Collections.enumeration(Collections.EMPTY_SET);
    }

    public Enumeration getServletNames() {
        return Collections.enumeration(Collections.EMPTY_SET);
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(Exception ex, String message) {
        System.out.println(message);
    }

    public void log(String message, Throwable ex) {
        System.out.println(message);
    }

    public String getRealPath(String path) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public String getServerInfo() {
        return "MockServletContext";
    }

    public String getInitParameter(String name) {
        Assert.notNull(name, "Parameter name must not be null");
        return this.initParameters.getProperty(name);
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Parameter name must not be null");
        this.initParameters.setProperty(name, value);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public Object getAttribute(String name) {
        Assert.notNull(name, "Attribute name must not be null");
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) {
        Assert.notNull(name, "Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        Assert.notNull(name, "Attribute name must not be null");
        this.attributes.remove(name);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }
}

