/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.server.tjws;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.resteasy.plugins.server.embedded.SecurityDomain;
import org.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.resteasy.plugins.server.tjws.AuthenticatedHttpServletRequest;
import org.resteasy.plugins.server.tjws.PatchedHttpServletRequest;

public class TJWSServletDispatcher
extends HttpServletDispatcher {
    private SecurityDomain domain;
    private String contextPath = "";

    public TJWSServletDispatcher() {
    }

    public TJWSServletDispatcher(SecurityDomain domain) {
        this.domain = domain;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            contextPath = "";
        } else if (contextPath.equals("/")) {
            contextPath = "";
        }
        this.contextPath = contextPath;
    }

    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.domain != null) {
            String auth = request.getHeader("Authorization");
            if (auth != null && auth.length() > 5) {
                String type = auth.substring(0, 5);
                if ("basic".equals(type = type.toLowerCase())) {
                    String cookie = auth.substring(6);
                    cookie = new String(Base64.decodeBase64((byte[])cookie.getBytes()));
                    String[] split = cookie.split(":");
                    Principal user = null;
                    try {
                        user = this.domain.authenticate(split[0], split[1]);
                    }
                    catch (SecurityException e) {
                        response.sendError(401);
                        return;
                    }
                    request = new AuthenticatedHttpServletRequest(request, this.domain, user, "BASIC", this.contextPath);
                }
            }
        } else {
            request = new PatchedHttpServletRequest(request, this.contextPath);
        }
        super.service(httpMethod, request, response);
    }

    public void setSecurityDomain(SecurityDomain domain) {
        this.domain = domain;
    }
}

