/*
 * Decompiled with CFR 0.152.
 */
package org.restfeeds.server;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.logging.Logger;
import org.restfeeds.server.FeedItem;
import org.restfeeds.server.FeedItemRepository;

public class RestFeedEndpoint {
    private static final Logger log = Logger.getLogger(RestFeedEndpoint.class.getName());
    private final FeedItemRepository feedItemRepository;
    private final Duration pollInterval;
    private final Duration timeout;

    public RestFeedEndpoint(FeedItemRepository feedItemRepository) {
        this(feedItemRepository, Duration.of(50L, ChronoUnit.MILLIS), Duration.of(5L, ChronoUnit.SECONDS));
    }

    public RestFeedEndpoint(FeedItemRepository feedItemRepository, Duration pollInterval, Duration timeout) {
        this.feedItemRepository = feedItemRepository;
        this.pollInterval = pollInterval;
        this.timeout = timeout;
    }

    public List<FeedItem> fetch(String feed, long offset, int limit) {
        Instant timeoutTimestamp = Instant.now().plus(this.timeout);
        log.fine(() -> String.format("Poll for items in feed %s with offset=%s timeout=%s", feed, offset, this.timeout));
        while (true) {
            List<FeedItem> items;
            int numberOfItems;
            if ((numberOfItems = (items = this.feedItemRepository.findByFeedPositionGreaterThanEqual(feed, offset, limit)).size()) > 0) {
                log.fine(() -> String.format("Returning %s items.", numberOfItems));
                return items;
            }
            if (Instant.now().isAfter(timeoutTimestamp)) {
                log.fine("Polling timed out. Returning the empty response.");
                return items;
            }
            try {
                log.finest("No items found. Wait a bit and then retry again.");
                Thread.sleep(this.pollInterval.toMillis());
            }
            catch (InterruptedException e) {
                log.fine("Thread was interrupted. Probably a graceful shutdown. Try to send response.");
                return items;
            }
        }
    }
}

