/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.html.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.ext.html.FormData;
import org.restlet.ext.html.internal.FormUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

@Deprecated
public class FormReader {
    private volatile CharacterSet characterSet;
    private volatile boolean decoding;
    private volatile char separator;
    private volatile InputStream stream;

    public FormReader(Representation representation) throws IOException {
        this.decoding = true;
        this.stream = representation.getStream();
        this.separator = (char)38;
        this.characterSet = representation.getCharacterSet() != null ? representation.getCharacterSet() : CharacterSet.UTF_8;
    }

    public FormReader(String queryString, char separator) {
        this.decoding = false;
        this.stream = new ByteArrayInputStream(queryString.getBytes());
        this.characterSet = null;
        this.separator = separator;
    }

    public FormReader(String queryString, CharacterSet characterSet, char separator) {
        this.decoding = true;
        this.stream = new ByteArrayInputStream(queryString.getBytes());
        this.characterSet = characterSet;
        this.separator = separator;
    }

    public void addEntries(Series<FormData> entries) {
        boolean readNext = true;
        FormData entry = null;
        if (this.stream != null) {
            try {
                while (readNext) {
                    entry = this.readNextEntry();
                    if (entry != null) {
                        entries.add((Object)entry);
                        continue;
                    }
                    readNext = false;
                }
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse a form entry. Skipping the remaining entries.", ioe);
            }
            try {
                this.stream.close();
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to close the form input stream", ioe);
            }
        }
    }

    public Series<FormData> read() throws IOException {
        Series result = new Series(FormData.class);
        FormData entry = this.readNextEntry();
        while (entry != null) {
            result.add((Object)entry);
            entry = this.readNextEntry();
        }
        this.stream.close();
        return result;
    }

    public void readEntries(Map<String, Object> entries) throws IOException {
        FormData entry = this.readNextEntry();
        Object currentValue = null;
        while (entry != null) {
            if (entries.containsKey(entry.getName())) {
                currentValue = entries.get(entry.getName());
                if (currentValue != null) {
                    ArrayList<Object> values = null;
                    if (currentValue instanceof List) {
                        values = (ArrayList<Object>)currentValue;
                    } else {
                        values = new ArrayList<Object>();
                        values.add(currentValue);
                        entries.put(entry.getName(), values);
                    }
                    if (entry.getValue() == null) {
                        values.add(Series.EMPTY_VALUE);
                    } else {
                        values.add(entry.getValue());
                    }
                } else if (entry.getValue() == null) {
                    entries.put(entry.getName(), Series.EMPTY_VALUE);
                } else {
                    entries.put(entry.getName(), entry.getValue());
                }
            }
            entry = this.readNextEntry();
        }
        this.stream.close();
    }

    public Object readEntry(String name) throws IOException {
        FormData entry = this.readNextEntry();
        Object result = null;
        while (entry != null) {
            if (entry.getName().equals(name)) {
                if (result != null) {
                    ArrayList<Object> values = null;
                    if (result instanceof List) {
                        values = (ArrayList<Object>)result;
                    } else {
                        values = new ArrayList<Object>();
                        values.add(result);
                        result = values;
                    }
                    if (entry.getValue() == null) {
                        values.add(Series.EMPTY_VALUE);
                    } else {
                        values.add(entry.getValue());
                    }
                } else {
                    result = entry.getValue() == null ? Series.EMPTY_VALUE : entry.getValue();
                }
            }
            entry = this.readNextEntry();
        }
        this.stream.close();
        return result;
    }

    public FormData readFirstEntry(String name) throws IOException {
        FormData entry = this.readNextEntry();
        FormData result = null;
        while (entry != null && result == null) {
            if (entry.getName().equals(name)) {
                result = entry;
            }
            entry = this.readNextEntry();
        }
        this.stream.close();
        return result;
    }

    public FormData readNextEntry() throws IOException {
        FormData result = null;
        try {
            boolean readingName = true;
            boolean readingValue = false;
            StringBuilder nameBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            char nextChar = '\u0000';
            while (result == null && nextChar != '\uffffffff') {
                nextChar = this.stream.read();
                if (readingName) {
                    if (nextChar == '=') {
                        if (nameBuffer.length() > 0) {
                            readingName = false;
                            readingValue = true;
                            continue;
                        }
                        throw new IOException("Empty entry name detected. Please check your form data");
                    }
                    if (nextChar == this.separator || nextChar == '\uffffffff') {
                        if (nameBuffer.length() > 0) {
                            result = FormUtils.create(nameBuffer, null, this.decoding, this.characterSet);
                            continue;
                        }
                        if (nextChar == '\uffffffff') continue;
                        Context.getCurrentLogger().fine("Empty entry name detected. Please check your form data");
                        continue;
                    }
                    nameBuffer.append(nextChar);
                    continue;
                }
                if (!readingValue) continue;
                if (nextChar == this.separator || nextChar == '\uffffffff') {
                    if (valueBuffer.length() > 0) {
                        result = FormUtils.create(nameBuffer, valueBuffer, this.decoding, this.characterSet);
                        continue;
                    }
                    result = FormUtils.create(nameBuffer, null, this.decoding, this.characterSet);
                    continue;
                }
                valueBuffer.append(nextChar);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException("Unsupported encoding. Please contact the administrator");
        }
        return result;
    }
}

