/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxb;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBSource;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxb.internal.Marshaller;
import org.restlet.ext.jaxb.internal.Unmarshaller;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

public class JaxbRepresentation<T>
extends WriterRepresentation {
    private static final Map<String, JAXBContext> contexts = new ConcurrentHashMap<String, JAXBContext>();
    private volatile ClassLoader classLoader;
    private volatile String contextPath;
    private volatile boolean expandingEntityRefs;
    private volatile boolean formattedOutput;
    private volatile boolean fragment;
    private volatile NamespacePrefixMapper namespacePrefixMapper;
    private volatile String noNamespaceSchemaLocation;
    private volatile T object;
    private volatile String schemaLocation;
    private boolean secureProcessing;
    private volatile boolean validatingDtd;
    private volatile ValidationEventHandler validationEventHandler;
    private volatile boolean xIncludeAware;
    private volatile Representation xmlRepresentation;

    public static synchronized JAXBContext getContext(String contextPath) throws JAXBException {
        return JaxbRepresentation.getContext(contextPath, null);
    }

    public static synchronized JAXBContext getContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        JAXBContext result = contexts.get(contextPath);
        if (result == null) {
            result = classLoader == null ? JAXBContext.newInstance((String)contextPath) : JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader);
            contexts.put(contextPath, result);
        }
        return result;
    }

    public JaxbRepresentation(MediaType mediaType, T object) {
        this(mediaType, object, object != null ? object.getClass().getClassLoader() : null);
    }

    public JaxbRepresentation(MediaType mediaType, T object, ClassLoader classloader) {
        super(mediaType);
        this.classLoader = classloader;
        this.contextPath = object != null ? object.getClass().getPackage().getName() : null;
        this.object = object;
        this.validationEventHandler = null;
        this.xmlRepresentation = null;
        this.expandingEntityRefs = false;
        this.formattedOutput = false;
        this.fragment = false;
        this.namespacePrefixMapper = null;
        this.noNamespaceSchemaLocation = null;
        this.schemaLocation = null;
        this.secureProcessing = true;
        this.validatingDtd = false;
        this.xIncludeAware = false;
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type) {
        this(xmlRepresentation, type.getPackage().getName(), null, type.getClassLoader());
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type, ValidationEventHandler validationHandler) {
        this(xmlRepresentation, type.getPackage().getName(), validationHandler, type.getClassLoader());
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath) {
        this(xmlRepresentation, contextPath, null, null);
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath, ValidationEventHandler validationHandler) {
        this(xmlRepresentation, contextPath, validationHandler, null);
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath, ValidationEventHandler validationHandler, ClassLoader classLoader) {
        super(xmlRepresentation == null ? null : xmlRepresentation.getMediaType());
        this.classLoader = classLoader;
        this.contextPath = contextPath;
        this.object = null;
        this.secureProcessing = true;
        this.validationEventHandler = validationHandler;
        this.xmlRepresentation = xmlRepresentation;
    }

    public JaxbRepresentation(T object) {
        this(MediaType.APPLICATION_XML, object);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JAXBContext getContext() throws JAXBException {
        return JaxbRepresentation.getContext(this.getContextPath(), this.getClassLoader());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public JAXBSource getJaxbSource() throws IOException {
        try {
            return new JAXBSource(this.getContext(), this.getObject());
        }
        catch (JAXBException e) {
            throw new IOException("JAXBException while creating the JAXBSource: " + e.getMessage());
        }
    }

    public NamespacePrefixMapper getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public T getObject() throws IOException {
        if (this.object == null && this.xmlRepresentation != null) {
            Unmarshaller u = new Unmarshaller(this.contextPath, this.classLoader);
            if (this.getValidationEventHandler() != null) {
                try {
                    u.setEventHandler(this.getValidationEventHandler());
                }
                catch (JAXBException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to set the event handler", e);
                    throw new IOException("Unable to set the event handler." + e.getMessage());
                }
            }
            try {
                this.object = u.unmarshal(this, this.xmlRepresentation.getReader());
            }
            catch (JAXBException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to unmarshal the XML representation", e);
                throw new IOException("Unable to unmarshal the XML representation." + e.getMessage());
            }
        }
        return this.object;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public boolean isExpandingEntityRefs() {
        return this.expandingEntityRefs;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing;
    }

    public boolean isValidatingDtd() {
        return this.validatingDtd;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setExpandingEntityRefs(boolean expandEntityRefs) {
        this.expandingEntityRefs = expandEntityRefs;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public void setNamespacePrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    public void setNoNamespaceSchemaLocation(String noNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setSecureProcessing(boolean secureProcessing) {
        this.secureProcessing = secureProcessing;
    }

    public void setValidatingDtd(boolean validating) {
        this.validatingDtd = validating;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void setXIncludeAware(boolean includeAware) {
        this.xIncludeAware = includeAware;
    }

    public void write(Writer writer) throws IOException {
        try {
            new Marshaller(this, this.contextPath, this.getClassLoader()).marshal(this.getObject(), writer);
        }
        catch (JAXBException e) {
            Context.getCurrentLogger().log(Level.WARNING, "JAXB marshalling error caught.", e);
            try {
                new Marshaller(this, "failure", this.getClassLoader()).marshal(this.getObject(), writer);
            }
            catch (JAXBException e2) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

