/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.servlet.ServletAdapter;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.FrameworkServlet;

public class RestletFrameworkServlet
extends FrameworkServlet {
    private static final String DEFAULT_TARGET_RESTLET_BEAN_NAME = "root";
    private static final long serialVersionUID = 1L;
    private volatile ServletAdapter adapter;
    private volatile String targetRestletBeanName;

    protected Context createContext() {
        return new Context();
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getAdapter().service(request, response);
    }

    protected ServletAdapter getAdapter() {
        return this.adapter;
    }

    protected Restlet getTargetRestlet() {
        return (Restlet)this.getWebApplicationContext().getBean(this.getTargetRestletBeanName());
    }

    public String getTargetRestletBeanName() {
        return this.targetRestletBeanName == null ? DEFAULT_TARGET_RESTLET_BEAN_NAME : this.targetRestletBeanName;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
        Application application;
        super.initFrameworkServlet();
        this.adapter = new ServletAdapter(this.getServletContext());
        if (this.getTargetRestlet() instanceof Application) {
            application = (Application)this.getTargetRestlet();
        } else {
            application = new Application();
            application.setInboundRoot(this.getTargetRestlet());
        }
        if (application.getContext() == null) {
            application.setContext(this.createContext());
        }
        this.adapter.setNext((Restlet)application);
    }

    public void setTargetRestletBeanName(String targetRestletBeanName) {
        this.targetRestletBeanName = targetRestletBeanName;
    }
}

