/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import java.util.Map;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.spring.SpringBeanFinder;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanRouter
extends Router
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    private volatile ApplicationContext applicationContext;
    private Map<String, String> attachments;
    private volatile boolean findingInAncestors = true;

    public SpringBeanRouter() {
    }

    public SpringBeanRouter(Context context) {
        super(context);
    }

    public SpringBeanRouter(Restlet parent) {
        super(parent.getContext());
    }

    private void attachAllResources(ListableBeanFactory beanFactory) {
        for (String beanName : this.getBeanNamesByType(ServerResource.class, beanFactory)) {
            String uri = this.resolveUri(beanName, beanFactory);
            if (uri == null) continue;
            this.attachResource(uri, beanName, (BeanFactory)beanFactory);
        }
    }

    private void attachAllRestlets(ListableBeanFactory beanFactory) {
        for (String beanName : this.getBeanNamesByType(Restlet.class, beanFactory)) {
            String uri = this.resolveUri(beanName, beanFactory);
            if (uri == null) continue;
            this.attachRestlet(uri, beanName, (BeanFactory)beanFactory);
        }
    }

    protected void attachResource(String uri, String beanName, BeanFactory beanFactory) {
        this.attach(uri, (Restlet)this.createFinder(beanFactory, beanName));
    }

    protected void attachRestlet(String uri, String beanName, BeanFactory beanFactory) {
        this.attach(uri, (Restlet)beanFactory.getBean(beanName));
    }

    protected Finder createFinder(BeanFactory beanFactory, String beanName) {
        return new SpringBeanFinder(this, beanFactory, beanName);
    }

    protected Map<String, String> getAttachments() {
        return this.attachments;
    }

    private String[] getBeanNamesByType(Class<?> beanClass, ListableBeanFactory beanFactory) {
        return this.isFindingInAncestors() ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanClass, (boolean)true, (boolean)true) : beanFactory.getBeanNamesForType(beanClass, true, true);
    }

    private boolean isAvailableUri(String name) {
        return name.startsWith("/") && (this.getAttachments() == null || !this.getAttachments().containsKey(name));
    }

    public boolean isFindingInAncestors() {
        return this.findingInAncestors;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurableListableBeanFactory source = this.applicationContext == null ? beanFactory : this.applicationContext;
        this.attachAllResources((ListableBeanFactory)source);
        this.attachAllRestlets((ListableBeanFactory)source);
        if (this.getAttachments() != null) {
            for (Map.Entry<String, String> attachment : this.getAttachments().entrySet()) {
                String uri = attachment.getKey();
                String beanName = attachment.getValue();
                Class beanType = source.getType(beanName);
                if (ServerResource.class.isAssignableFrom(beanType)) {
                    this.attachResource(uri, beanName, (BeanFactory)source);
                    continue;
                }
                if (Restlet.class.isAssignableFrom(beanType)) {
                    this.attachRestlet(uri, beanName, (BeanFactory)source);
                    continue;
                }
                throw new IllegalStateException(beanName + " is not routable.  It must be either a Resource, a ServerResource or a Restlet.");
            }
        }
    }

    protected String resolveUri(String beanName, ListableBeanFactory beanFactory) {
        if (this.isAvailableUri(beanName)) {
            return beanName;
        }
        for (String alias : beanFactory.getAliases(beanName)) {
            if (!this.isAvailableUri(alias)) continue;
            return alias;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments;
    }

    public void setFindingInAncestors(boolean findingInAncestors) {
        this.findingInAncestors = findingInAncestors;
    }
}

