/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Protocol;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.routing.Filter;
import org.restlet.routing.Template;

public class TemplateDispatcher
extends Filter {
    @Override
    protected void afterHandle(Request request, Response response) {
        if (response.getEntity() != null && response.getEntity().getLocationRef() == null) {
            response.getEntity().setLocationRef(request.getResourceRef().getTargetRef().toString());
        }
    }

    @Override
    public int beforeHandle(Request request, Response response) {
        Protocol protocol = request.getProtocol();
        if (protocol == null) {
            throw new UnsupportedOperationException("Unable to determine the protocol to use for this call.");
        }
        String targetUri = request.getResourceRef().toString(true, false);
        if (targetUri.contains("{")) {
            Template template = new Template(targetUri);
            request.setResourceRef(template.format(request, response));
        }
        request.setOriginalRef(ReferenceUtils.getOriginalRef(request.getResourceRef(), request.getHeaders()));
        return 0;
    }
}

