/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.engine.util.StringUtils;

public final class Protocol {
    public static final int UNKNOWN_PORT = -1;
    public static final Protocol ALL = new Protocol("all", "ALL", "Wildcard for all protocols", -1);
    public static final Protocol CLAP = new Protocol("clap", "CLAP", "Class Loader Access Protocol", -1, true);
    public static final Protocol FILE = new Protocol("file", "FILE", "Local File System Protocol", -1, true);
    public static final Protocol FTP = new Protocol("ftp", "FTP", "File Transfer Protocol", 21);
    public static final Protocol HTTP = new Protocol("http", "HTTP", "HyperText Transport Protocol", 80, "1.1");
    public static final Protocol HTTPS = new Protocol("https", "HTTPS", "HTTP", "HyperText Transport Protocol (Secure)", 443, true, "1.1");
    public static final Protocol JAR = new Protocol("jar", "JAR", "Java ARchive", -1, true);
    public static final Protocol JDBC = new Protocol("jdbc", "JDBC", "Java DataBase Connectivity", -1);
    public static final Protocol RIAP = new Protocol("riap", "RIAP", "Restlet Internal Access Protocol", -1, true);
    public static final Protocol WAR = new Protocol("war", "WAR", "Web Archive Access Protocol", -1, true);
    public static final Protocol ZIP = new Protocol("zip", "ZIP", "Zip Archive Access Protocol", -1, true);
    private final boolean confidential;
    private final int defaultPort;
    private final String description;
    private final String name;
    private final String schemeName;
    private final String technicalName;
    private final String version;

    public static Protocol valueOf(String name) {
        Protocol result = null;
        if (!StringUtils.isNullOrEmpty(name)) {
            result = name.equalsIgnoreCase(CLAP.getSchemeName()) ? CLAP : (name.equalsIgnoreCase(FILE.getSchemeName()) ? FILE : (name.equalsIgnoreCase(FTP.getSchemeName()) ? FTP : (name.equalsIgnoreCase(HTTP.getSchemeName()) ? HTTP : (name.equalsIgnoreCase(HTTPS.getSchemeName()) ? HTTPS : (name.equalsIgnoreCase(JAR.getSchemeName()) ? JAR : (name.equalsIgnoreCase(JDBC.getSchemeName()) ? JDBC : (name.equalsIgnoreCase(RIAP.getSchemeName()) ? RIAP : (name.equalsIgnoreCase(WAR.getSchemeName()) ? WAR : (name.equalsIgnoreCase(ZIP.getSchemeName()) ? ZIP : new Protocol(name))))))))));
        }
        return result;
    }

    public static Protocol valueOf(String name, String version) {
        Protocol result = Protocol.valueOf(name);
        if (!version.equals(result.getVersion())) {
            result = new Protocol(result.getSchemeName(), result.getName(), result.getTechnicalName(), result.getDescription(), result.getDefaultPort(), result.isConfidential(), version);
        }
        return result;
    }

    public Protocol(String schemeName) {
        this(schemeName, schemeName.toUpperCase(), schemeName.toUpperCase() + " Protocol", -1);
    }

    public Protocol(String schemeName, String name, String description, int defaultPort) {
        this(schemeName, name, description, defaultPort, false);
    }

    public Protocol(String schemeName, String name, String description, int defaultPort, boolean confidential) {
        this(schemeName, name, description, defaultPort, confidential, null);
    }

    public Protocol(String schemeName, String name, String description, int defaultPort, boolean confidential, String version) {
        this(schemeName, name, name, description, defaultPort, confidential, version);
    }

    public Protocol(String schemeName, String name, String description, int defaultPort, String version) {
        this(schemeName, name, description, defaultPort, false, version);
    }

    public Protocol(String schemeName, String name, String technicalName, String description, int defaultPort, boolean confidential, String version) {
        this.name = name;
        this.description = description;
        this.schemeName = schemeName;
        this.technicalName = technicalName;
        this.defaultPort = defaultPort;
        this.confidential = confidential;
        this.version = version;
    }

    public boolean equals(Object object) {
        return object instanceof Protocol && this.getName().equalsIgnoreCase(((Protocol)object).getName());
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public String toString() {
        return this.getName() + (String)(this.getVersion() == null ? "" : "/" + this.getVersion());
    }
}

