/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine;

public enum Edition {
    ANDROID("Android", "Android", "Android"),
    JEE("Java Enterprise Edition", "Java EE", "JEE"),
    JSE("Java Standard Edition", "Java SE", "JSE");

    public static Edition CURRENT;
    private final String fullName;
    private final String mediumName;
    private final String shortName;

    private Edition(String fullName, String mediumName, String shortName) {
        this.fullName = fullName;
        this.mediumName = mediumName;
        this.shortName = shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getMediumName() {
        return this.mediumName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isCurrentEdition() {
        return this == CURRENT;
    }

    public boolean isNotCurrentEdition() {
        return this != CURRENT;
    }

    public static boolean isCurrentEditionOneOf(Edition ... editions) {
        boolean result = false;
        if (editions != null) {
            for (int i = 0; i < editions.length && !result; ++i) {
                result = editions[i].isCurrentEdition();
            }
        }
        return result;
    }

    public void setCurrentEdition() {
        CURRENT = this;
    }

    static {
        CURRENT = JSE;
    }
}

