/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.application.StatusFilter;
import org.restlet.engine.application.StatusInfo;
import org.restlet.engine.converter.ConverterUtils;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.engine.resource.ThrowableAnnotationInfo;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Filter;
import org.restlet.service.ConnegService;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;
import org.restlet.service.Service;

public class StatusService
extends Service {
    private volatile ConnegService connegService;
    private volatile String contactEmail;
    private volatile ConverterService converterService;
    private volatile Reference homeRef;
    private volatile MetadataService metadataService;
    private volatile boolean overwriting;

    public StatusService() {
        this(true);
    }

    public StatusService(boolean enabled) {
        this(enabled, new ConverterService(), new MetadataService(), new ConnegService());
    }

    public StatusService(boolean enabled, ConverterService converterService, MetadataService metadataService, ConnegService connegService) {
        super(enabled);
        this.converterService = converterService;
        this.metadataService = metadataService;
        this.connegService = connegService;
        this.contactEmail = null;
        this.homeRef = new Reference("/");
        this.overwriting = false;
    }

    @Override
    public Filter createInboundFilter(Context context) {
        return new StatusFilter(context, this);
    }

    public ConnegService getConnegService() {
        return this.connegService;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public ConverterService getConverterService() {
        return this.converterService;
    }

    public Reference getHomeRef() {
        return this.homeRef;
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    public boolean isOverwriting() {
        return this.overwriting;
    }

    public void setConnegService(ConnegService connegService) {
        this.connegService = connegService;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public void setConverterService(ConverterService converterService) {
        this.converterService = converterService;
    }

    public void setHomeRef(Reference homeRef) {
        this.homeRef = homeRef;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setOverwriting(boolean overwriting) {
        this.overwriting = overwriting;
    }

    public Representation toRepresentation(Status status, Request request, Response response) {
        Representation result = null;
        if (this.converterService != null && this.connegService != null && this.metadataService != null) {
            ThrowableAnnotationInfo tai;
            Object representationObject = null;
            Throwable cause = status.getThrowable();
            if (cause != null && (tai = AnnotationUtils.getInstance().getThrowableAnnotationInfo(cause.getClass())) != null && tai.isSerializable()) {
                if (Application.getCurrent() != null && !Application.getCurrent().isDebugging()) {
                    cause.setStackTrace(new StackTraceElement[0]);
                    if (cause.getCause() != null) {
                        Context.getCurrentLogger().log(Level.WARNING, "The cause of the exception should be null except in debug mode");
                    }
                }
                representationObject = cause;
            }
            try {
                List<VariantInfo> variants;
                if (representationObject == null) {
                    representationObject = new StatusInfo(status, this.getContactEmail(), this.getHomeRef().toString());
                }
                if ((variants = ConverterUtils.getVariants(representationObject.getClass(), null)) == null) {
                    variants = new ArrayList<VariantInfo>();
                }
                Variant variant = this.connegService.getPreferredVariant(variants, request, this.metadataService);
                result = this.converterService.toRepresentation(representationObject, variant);
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Could not serialize throwable class " + String.valueOf(cause == null ? null : cause.getClass()), e);
            }
        }
        return result;
    }

    public Representation toRepresentation(Status status, Resource resource) {
        return this.toRepresentation(status, resource.getRequest(), resource.getResponse());
    }

    public Status toStatus(Throwable throwable, Request request, Response response) {
        ThrowableAnnotationInfo tai;
        Status defaultStatus = Status.SERVER_ERROR_INTERNAL;
        Throwable t = throwable;
        if (throwable instanceof ResourceException) {
            defaultStatus = ((ResourceException)throwable).getStatus();
            if (throwable.getCause() != null && throwable.getCause() != throwable) {
                t = throwable.getCause();
            }
        }
        Status result = (tai = AnnotationUtils.getInstance().getThrowableAnnotationInfo(t.getClass())) != null ? new Status(tai.getStatus(), t) : new Status(defaultStatus, t);
        return result;
    }

    public Status toStatus(Throwable throwable, Resource resource) {
        return this.toStatus(throwable, resource == null ? null : resource.getRequest(), resource == null ? null : resource.getResponse());
    }
}

