/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;

public abstract class CheckBase
implements Check {
    private TypeEnvironment oldTypeEnvironment;
    private TypeEnvironment newTypeEnvironment;
    private int depth;
    private final Deque<ActiveElements<?>> activations = new ArrayDeque();
    private AnalysisContext analysisContext;

    @Override
    public boolean isDescendingOnNonExisting() {
        return false;
    }

    public boolean isBothPrivate(@Nullable JavaModelElement a, @Nullable JavaModelElement b) {
        if (a == null || b == null) {
            return false;
        }
        return !this.isAccessible(a) && !this.isAccessible(b);
    }

    public boolean isBothAccessible(@Nullable JavaModelElement a, @Nullable JavaModelElement b) {
        if (a == null || b == null) {
            return false;
        }
        return this.isAccessible(a) && this.isAccessible(b);
    }

    public boolean isAccessible(@Nonnull JavaModelElement e) {
        if (!(e instanceof JavaMethodParameterElement) && !this.isAccessibleByModifier(e.getDeclaringElement())) {
            return false;
        }
        JavaModelElement parent = e.getParent();
        if (e instanceof JavaTypeElement) {
            return ((JavaTypeElement)e).isInAPI() && (parent == null || this._isAccessible(parent));
        }
        assert (parent != null);
        return this.isAccessible(parent);
    }

    private boolean _isAccessible(@Nonnull JavaModelElement e) {
        if (!this.isAccessibleByModifier(e.getDeclaringElement())) {
            return false;
        }
        JavaModelElement parent = e.getParent();
        return parent == null || this._isAccessible(parent);
    }

    private boolean isAccessibleByModifier(Element e) {
        return !this.isMissing(e) && (e.getModifiers().contains((Object)Modifier.PUBLIC) || e.getModifiers().contains((Object)Modifier.PROTECTED));
    }

    public boolean isMissing(@Nonnull Element e) {
        return e.asType().getKind() == TypeKind.ERROR;
    }

    @Nonnull
    protected Difference createDifference(@Nonnull Code code, String[] attachments) {
        return code.createDifference(this.getAnalysisContext().getLocale(), attachments);
    }

    @Nonnull
    protected Difference createDifferenceWithExplicitParams(@Nonnull Code code, String[] attachments, String ... params) {
        return code.createDifferenceWithExplicitParams(this.getAnalysisContext().getLocale(), attachments, params);
    }

    @Nonnull
    public TypeEnvironment getOldTypeEnvironment() {
        return this.oldTypeEnvironment;
    }

    @Nonnull
    public TypeEnvironment getNewTypeEnvironment() {
        return this.newTypeEnvironment;
    }

    @Nonnull
    public AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    @Nullable
    public String getExtensionId() {
        return null;
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    @Override
    public void setOldTypeEnvironment(@Nonnull TypeEnvironment env) {
        this.oldTypeEnvironment = env;
    }

    @Override
    public void setNewTypeEnvironment(@Nonnull TypeEnvironment env) {
        this.newTypeEnvironment = env;
    }

    @Override
    @Nullable
    public final List<Difference> visitEnd() {
        try {
            List<Difference> list = this.doEnd();
            return list;
        }
        finally {
            this.popIfActive();
            --this.depth;
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        return null;
    }

    @Override
    public final void visitClass(@Nullable JavaTypeElement oldType, @Nullable JavaTypeElement newType) {
        ++this.depth;
        this.doVisitClass(oldType, newType);
    }

    protected void doVisitClass(@Nullable JavaTypeElement oldType, @Nullable JavaTypeElement newType) {
    }

    @Override
    public final void visitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        ++this.depth;
        this.doVisitMethod(oldMethod, newMethod);
    }

    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
    }

    @Override
    public final void visitMethodParameter(@Nullable JavaMethodParameterElement oldParameter, @Nullable JavaMethodParameterElement newParameter) {
        ++this.depth;
        this.doVisitMethodParameter(oldParameter, newParameter);
    }

    protected void doVisitMethodParameter(@Nullable JavaMethodParameterElement oldParameter, @Nullable JavaMethodParameterElement newParameter) {
    }

    @Override
    public final void visitField(@Nullable JavaFieldElement oldField, @Nullable JavaFieldElement newField) {
        ++this.depth;
        this.doVisitField(oldField, newField);
    }

    protected void doVisitField(@Nullable JavaFieldElement oldField, @Nullable JavaFieldElement newField) {
    }

    @Override
    @Nullable
    public final List<Difference> visitAnnotation(@Nullable JavaAnnotationElement oldAnnotation, @Nullable JavaAnnotationElement newAnnotation) {
        ++this.depth;
        List<Difference> ret = this.doVisitAnnotation(oldAnnotation, newAnnotation);
        --this.depth;
        return ret;
    }

    @Nullable
    protected List<Difference> doVisitAnnotation(@Nullable JavaAnnotationElement oldAnnotation, @Nullable JavaAnnotationElement newAnnotation) {
        return null;
    }

    protected final <T extends JavaElement> void pushActive(@Nullable T oldElement, @Nullable T newElement, Object ... context) {
        ActiveElements r = new ActiveElements(this.depth, oldElement, newElement, context, null);
        this.activations.push(r);
    }

    @Nullable
    protected <T extends JavaElement> ActiveElements<T> popIfActive() {
        return !this.activations.isEmpty() && ((ActiveElements)this.activations.peek()).depth == this.depth ? this.activations.pop() : null;
    }

    protected static class ActiveElements<T extends JavaElement> {
        public final T oldElement;
        public final T newElement;
        public final Object[] context;
        private final int depth;

        private ActiveElements(int depth, T oldElement, T newElement, Object ... context) {
            this.depth = depth;
            this.oldElement = oldElement;
            this.newElement = newElement;
            this.context = context;
        }

        /* synthetic */ ActiveElements(int x0, JavaElement x1, JavaElement x2, Object[] x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

