/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.reporter.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.revapi.AnalysisContext;
import org.revapi.Criticality;
import org.revapi.DifferenceSeverity;
import org.revapi.Report;
import org.revapi.ReportComparator;
import org.revapi.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileReporter
implements Reporter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileReporter.class);
    protected DifferenceSeverity minLevel;
    protected Criticality minCriticality;
    protected PrintWriter output;
    protected File file;
    protected boolean shouldClose;
    protected boolean keepEmptyFile;
    protected AnalysisContext analysis;
    private boolean reportsInOutput = false;

    protected void setOutput(PrintWriter wrt) {
        this.output = wrt;
        this.shouldClose = true;
    }

    protected abstract void flushReports() throws IOException;

    public void initialize(@Nonnull AnalysisContext analysis) {
        OutputStream out;
        if (this.analysis != null) {
            try {
                this.flushReports();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to output previous analysis report.");
            }
        }
        this.analysis = analysis;
        String minLevel = analysis.getConfigurationNode().path("minSeverity").asText(null);
        String minCrit = analysis.getConfigurationNode().path("minCriticality").asText(null);
        String output = analysis.getConfigurationNode().path("output").asText(null);
        output = output == null ? "out" : output;
        boolean append = analysis.getConfigurationNode().path("append").asBoolean(false);
        boolean bl = this.keepEmptyFile = append || analysis.getConfigurationNode().path("keepEmptyFile").asBoolean(true);
        if (minLevel == null && minCrit == null) {
            LOG.warn("At least one of `minLevel` and `minCriticality` should to be defined. Defaulting to the obsolete behavior of reporting all potentially breaking elements.");
            this.minLevel = DifferenceSeverity.POTENTIALLY_BREAKING;
        }
        if (minLevel != null) {
            this.minLevel = DifferenceSeverity.valueOf((String)minLevel);
        }
        if (minCrit != null) {
            this.minCriticality = analysis.getCriticalityByName(minCrit);
            if (this.minCriticality == null) {
                throw new IllegalArgumentException("Unknown criticality '" + minCrit + "'.");
            }
        }
        switch (output) {
            case "out": {
                out = System.out;
                break;
            }
            case "err": {
                out = System.err;
                break;
            }
            default: {
                this.file = new File(output);
                if (this.file.exists()) {
                    if (!this.file.isFile()) {
                        LOG.warn("The configured file, '" + this.file.getAbsolutePath() + "' is not a file. Defaulting the output to standard output.");
                        out = System.out;
                        break;
                    }
                    if (!this.file.canWrite()) {
                        LOG.warn("The configured file, '" + this.file.getAbsolutePath() + "' is not a writable. Defaulting the output to standard output.");
                        out = System.out;
                        break;
                    }
                } else {
                    File parent = this.file.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        LOG.warn("Failed to create directory structure to write to the configured output file '" + this.file.getAbsolutePath() + "'. Defaulting the output to standard output.");
                        out = System.out;
                        break;
                    }
                }
                try {
                    out = new FileOutputStream(output, append);
                    break;
                }
                catch (FileNotFoundException e) {
                    LOG.warn("Failed to create the configured output file '" + this.file.getAbsolutePath() + "'. Defaulting the output to standard output.", (Throwable)e);
                    out = System.out;
                }
            }
        }
        this.shouldClose = out != System.out && out != System.err;
        this.output = this.createOutputWriter(out, analysis);
    }

    protected PrintWriter createOutputWriter(OutputStream stream, AnalysisContext ctx) {
        return new PrintWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
    }

    public void report(@Nonnull Report report) {
        LOG.trace("Received report {}", (Object)report);
        if (report.getDifferences().isEmpty()) {
            return;
        }
        if (this.isReportable(report)) {
            this.reportsInOutput = true;
            this.doReport(report);
        }
    }

    protected boolean isReportable(Report report) {
        boolean ret = true;
        if (this.minLevel != null) {
            ret = this.isReportableBySeverity(report);
        }
        if (this.minCriticality != null) {
            ret = ret && this.isReportableByCriticality(report);
        }
        return ret;
    }

    private boolean isReportableBySeverity(Report report) {
        return report.getDifferences().stream().flatMap(d -> d.classification.values().stream()).anyMatch(s -> s.compareTo((Enum)this.minLevel) >= 0);
    }

    private boolean isReportableByCriticality(Report report) {
        return report.getDifferences().stream().map(d -> d.criticality).filter(Objects::nonNull).anyMatch(c -> c.getLevel() >= this.minCriticality.getLevel());
    }

    protected abstract void doReport(Report var1);

    public void close() throws IOException {
        this.flushReports();
        if (this.shouldClose) {
            this.output.close();
        }
        if (!(this.keepEmptyFile || this.reportsInOutput || this.file == null || this.file.delete())) {
            LOG.warn("Failed to delete an empty output file: " + this.file.getAbsolutePath());
        }
    }

    protected Comparator<Report> getReportsByElementOrderComparator() {
        return new ReportComparator.Builder().withComparisonStrategy(ReportComparator.Strategy.HIERARCHICAL).build();
    }
}

