/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.reporter.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Report;
import org.revapi.reporter.file.AbstractFileReporter;

public class JsonReporter
extends AbstractFileReporter {
    private Set<Report> reports;
    private boolean prettyPrint;

    protected void setOutput(PrintWriter wrt) {
        super.setOutput(wrt);
    }

    public String getExtensionId() {
        return "revapi.reporter.json";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("schema.json"), StandardCharsets.UTF_8);
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        super.initialize(analysisContext);
        this.prettyPrint = analysisContext.getConfigurationNode().path("indent").asBoolean(false);
        this.reports = new TreeSet<Report>(this.getReportsByElementOrderComparator());
    }

    protected void flushReports() {
        try {
            JsonGenerator jsonGenerator = this.createGenerator();
            jsonGenerator.writeStartArray();
            this.reports.stream().flatMap(r -> {
                String oldEl = r.getOldElement() == null ? null : r.getOldElement().getFullHumanReadableString();
                String newEl = r.getNewElement() == null ? null : r.getNewElement().getFullHumanReadableString();
                return r.getDifferences().stream().map(d -> new DifferenceWithElements(oldEl, newEl, (Difference)d));
            }).forEach(d -> {
                try {
                    JsonReporter.writeDifference(jsonGenerator, d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write the output.", e);
                }
            });
            jsonGenerator.writeEndArray();
            jsonGenerator.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write the output.", e);
        }
    }

    protected void doReport(Report report) {
        this.reports.add(report);
    }

    private static void writeDifference(JsonGenerator gen, DifferenceWithElements de) throws IOException {
        gen.writeStartObject();
        Difference d = de.diff;
        JsonReporter.write(gen, "code", d.code);
        JsonReporter.write(gen, "old", de.oldEl);
        JsonReporter.write(gen, "new", de.newEl);
        JsonReporter.write(gen, "name", d.name);
        JsonReporter.write(gen, "description", d.description);
        JsonReporter.write(gen, "criticality", d.criticality == null ? null : d.criticality.getName());
        JsonReporter.write(gen, "justification", d.justification);
        gen.writeArrayFieldStart("classification");
        for (Map.Entry e : d.classification.entrySet()) {
            gen.writeStartObject();
            gen.writeStringField("compatibility", ((CompatibilityType)e.getKey()).toString());
            gen.writeStringField("severity", ((DifferenceSeverity)e.getValue()).toString());
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart("attachments");
        for (Map.Entry e : d.attachments.entrySet()) {
            gen.writeStartObject();
            gen.writeStringField("name", (String)e.getKey());
            JsonReporter.write(gen, "value", (String)e.getValue());
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    private JsonGenerator createGenerator() throws IOException {
        JsonGenerator jsonGenerator = JsonFactory.builder().build().createGenerator((Writer)this.output);
        if (this.prettyPrint) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        return jsonGenerator;
    }

    private static void write(JsonGenerator gen, String key, @Nullable String value) throws IOException {
        if (value == null) {
            gen.writeNullField(key);
        } else {
            gen.writeStringField(key, value);
        }
    }

    private static class DifferenceWithElements {
        final String oldEl;
        final String newEl;
        final Difference diff;

        private DifferenceWithElements(String oldEl, String newEl, Difference diff) {
            this.oldEl = oldEl;
            this.newEl = newEl;
            this.diff = diff;
        }
    }
}

