/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.reporter.text;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Reporter;
import org.revapi.reporter.text.NaiveFileTemplateLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextReporter
implements Reporter {
    private static final Logger LOG = LoggerFactory.getLogger(TextReporter.class);
    private static final String CONFIG_ROOT_PATH = "revapi.reporter.text";
    private DifferenceSeverity minLevel;
    private PrintWriter output;
    private boolean shouldClose;
    private SortedSet<Report> reports;
    private Template template;
    private AnalysisContext analysis;

    @Nullable
    public String getExtensionId() {
        return CONFIG_ROOT_PATH;
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/schema.json"), Charset.forName("UTF-8"));
    }

    void setOutput(PrintWriter wrt) {
        this.output = wrt;
        this.shouldClose = true;
    }

    public void initialize(@Nonnull AnalysisContext analysis) {
        OutputStream out;
        if (analysis != null) {
            try {
                this.flushReports();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to output previous analysis report.");
            }
        }
        this.analysis = analysis;
        String minLevel = analysis.getConfiguration().get("minSeverity").asString();
        String output = analysis.getConfiguration().get("output").asString();
        output = "undefined".equals(output) ? "out" : output;
        String templatePath = analysis.getConfiguration().get("template").asString();
        if ("undefined".equals(templatePath)) {
            templatePath = null;
        }
        boolean append = analysis.getConfiguration().get("append").asBoolean(false);
        this.minLevel = "undefined".equals(minLevel) ? DifferenceSeverity.POTENTIALLY_BREAKING : DifferenceSeverity.valueOf((String)minLevel);
        switch (output) {
            case "out": {
                out = System.out;
                break;
            }
            case "err": {
                out = System.err;
                break;
            }
            default: {
                File f = new File(output);
                if (f.exists() && !f.canWrite()) {
                    LOG.warn("The configured file for text reporter, '" + f.getAbsolutePath() + "' is not a writable file. Defaulting the output to standard output.");
                    out = System.out;
                    break;
                }
                File parent = f.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    LOG.warn("Failed to create directory structure to write to the configured output file '" + f.getAbsolutePath() + "'. Defaulting the output to standard output.");
                    out = System.out;
                    break;
                }
                try {
                    out = new FileOutputStream(output, append);
                    break;
                }
                catch (FileNotFoundException e) {
                    LOG.warn("Failed to create the configured output file '" + f.getAbsolutePath() + "'. Defaulting the output to standard output.", (Throwable)e);
                    out = System.out;
                }
            }
        }
        this.shouldClose = out != System.out && out != System.err;
        this.output = new PrintWriter(new OutputStreamWriter(out, Charset.forName("UTF-8")));
        this.reports = new TreeSet<Report>((r1, r2) -> {
            Element r2El = r2.getOldElement() == null ? r2.getNewElement() : r2.getOldElement();
            ArrayDeque<Element> r1Ancestry = new ArrayDeque<Element>();
            ArrayDeque<Element> r2Ancestry = new ArrayDeque<Element>();
            for (Element r1El = r1.getOldElement() == null ? r1.getNewElement() : r1.getOldElement(); r1El != null; r1El = r1El.getParent()) {
                r1Ancestry.push(r1El);
            }
            while (r2El != null) {
                r2Ancestry.push(r2El);
                r2El = r2El.getParent();
            }
            while (!r1Ancestry.isEmpty() && !r2Ancestry.isEmpty()) {
                int order = ((Element)r1Ancestry.pop()).compareTo(r2Ancestry.pop());
                if (order == 0) continue;
                return order;
            }
            return r1Ancestry.size() - r2Ancestry.size();
        });
        Configuration freeMarker = this.createFreeMarkerConfiguration();
        this.template = null;
        try {
            this.template = templatePath == null ? freeMarker.getTemplate("default-template-with-improbable-name@@#(*&$)(.ftl") : freeMarker.getTemplate(templatePath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the freemarker template.", e);
        }
    }

    protected Configuration createFreeMarkerConfiguration() {
        DefaultObjectWrapperBuilder bld = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_23);
        bld.setExposeFields(true);
        Configuration freeMarker = new Configuration(Configuration.VERSION_2_3_23);
        freeMarker.setObjectWrapper((ObjectWrapper)bld.build());
        freeMarker.setAPIBuiltinEnabled(true);
        freeMarker.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{new ClassTemplateLoader(this.getClass(), "/META-INF"), new NaiveFileTemplateLoader()}));
        return freeMarker;
    }

    public void report(@Nonnull Report report) {
        LOG.trace("Received report {}", (Object)report);
        if (report.getDifferences().isEmpty()) {
            return;
        }
        DifferenceSeverity maxReportedSeverity = DifferenceSeverity.NON_BREAKING;
        for (Difference d : report.getDifferences()) {
            for (DifferenceSeverity c : d.classification.values()) {
                if (c.compareTo((Enum)maxReportedSeverity) <= 0) continue;
                maxReportedSeverity = c;
            }
        }
        if (maxReportedSeverity.compareTo((Enum)this.minLevel) < 0) {
            return;
        }
        this.reports.add(report);
    }

    public void close() throws IOException {
        this.flushReports();
        if (this.shouldClose) {
            this.output.close();
        }
    }

    private void flushReports() throws IOException {
        try {
            if (this.output != null && this.template != null) {
                HashMap<String, SortedSet<Object>> root = new HashMap<String, SortedSet<Object>>();
                root.put("reports", this.reports);
                root.put("analysis", (SortedSet<Object>)this.analysis);
                this.template.process(root, (Writer)this.output);
            }
        }
        catch (TemplateException e) {
            throw new IOException("Failed to output the reports.", e);
        }
    }
}

