/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.reporter.text;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Report;
import org.revapi.reporter.file.AbstractFileReporter;
import org.revapi.reporter.text.NaiveFileTemplateLoader;

public class TextReporter
extends AbstractFileReporter {
    private static final String CONFIG_ROOT_PATH = "revapi.reporter.text";
    private SortedSet<Report> reports;
    private Template template;

    protected void setOutput(PrintWriter wrt) {
        super.setOutput(wrt);
    }

    @Nullable
    public String getExtensionId() {
        return CONFIG_ROOT_PATH;
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("schema.json"), StandardCharsets.UTF_8);
    }

    public void initialize(@Nonnull AnalysisContext analysis) {
        super.initialize(analysis);
        String templatePath = analysis.getConfigurationNode().path("template").asText("");
        if (templatePath.isEmpty()) {
            templatePath = null;
        }
        this.reports = new TreeSet<Report>(this.getReportsByElementOrderComparator());
        Configuration freeMarker = this.createFreeMarkerConfiguration();
        this.template = null;
        try {
            this.template = templatePath == null ? freeMarker.getTemplate("default-template-with-improbable-name.ftl") : freeMarker.getTemplate(templatePath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the freemarker template.", e);
        }
    }

    protected Configuration createFreeMarkerConfiguration() {
        DefaultObjectWrapperBuilder bld = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_23);
        bld.setExposeFields(true);
        Configuration freeMarker = new Configuration(Configuration.VERSION_2_3_23);
        freeMarker.setObjectWrapper((ObjectWrapper)bld.build());
        freeMarker.setAPIBuiltinEnabled(true);
        freeMarker.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{new ClassTemplateLoader(((Object)((Object)this)).getClass(), "/META-INF"), new NaiveFileTemplateLoader()}));
        return freeMarker;
    }

    protected void doReport(@Nonnull Report report) {
        this.reports.add(report);
    }

    protected void flushReports() throws IOException {
        try {
            if (this.output != null && this.template != null) {
                HashMap<String, SortedSet<Object>> root = new HashMap<String, SortedSet<Object>>();
                root.put("reports", this.reports);
                root.put("analysis", (SortedSet<Object>)this.analysis);
                this.template.process(root, (Writer)this.output);
            }
        }
        catch (TemplateException e) {
            throw new IOException("Failed to output the reports.", e);
        }
    }
}

