/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.openshift;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.StandaloneASComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;

public class OpenshiftComponent
extends StandaloneASComponent<BaseComponent<?>>
implements MeasurementFacet {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final int CHANGEME = 1;
    private ResourceContext context;
    private StandaloneASComponent parent;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        Configuration conf = context.getPluginConfiguration();
        this.parent = (StandaloneASComponent)context.getParentResourceComponent();
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            if (!req.getName().equals("appuid")) continue;
            Address addr = new Address("core-service=platform-mbean,type=runtime");
            ReadAttribute op = new ReadAttribute(addr, "system-properties");
            ASConnection conn = this.parent.getASConnection();
            ComplexResult result = conn.executeComplex((Operation)op);
            if (result.isSuccess()) {
                Map data = result.getResult();
                if (!data.containsKey("OPENSHIFT_APP_UUID")) continue;
                String uid = (String)data.get("OPENSHIFT_APP_UUID");
                MeasurementDataTrait res = new MeasurementDataTrait(req, uid);
                report.addData(res);
                continue;
            }
            this.log.warn((Object)("Operation failed: " + result.getFailureDescription()));
        }
    }
}

