/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertIrc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertIrc.IrcAlertComponent;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcSender
extends AlertSender<IrcAlertComponent> {
    private final Log log = LogFactory.getLog(IrcSender.class);

    public SenderResult send(Alert alert) {
        SenderResult result;
        String channel = this.alertParameters.getSimpleValue("channel", null);
        String server = this.preferences.getSimpleValue("server", "-not set-");
        String chan = "irc://" + server + "/" + channel;
        try {
            ((IrcAlertComponent)this.pluginComponent).sendIrcMessage(channel, this.getIrcMessage(alert));
            result = new SenderResult(ResultState.SUCCESS, "IRC Alert sent to channel [" + chan + "].");
        }
        catch (IllegalStateException e) {
            this.log.error((Object)e.getMessage());
            result = new SenderResult(ResultState.FAILURE, "IRC Alert to [" + chan + "] failed! " + e.getMessage());
        }
        return result;
    }

    private String getIrcMessage(Alert alert) {
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        StringBuilder b = new StringBuilder("Alert -- ");
        b.append(alert.getAlertDefinition().getName());
        b.append(" (on ");
        b.append(alert.getAlertDefinition().getResource().getName());
        b.append("):  ");
        b.append(alertManager.prettyPrintAlertURL(alert));
        b.append("\n");
        b.append(alertManager.prettyPrintAlertConditions(alert, false));
        return b.toString();
    }
}

