/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertUps;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aerogear.unifiedpush.SenderClient;
import org.jboss.aerogear.unifiedpush.message.MessageResponseCallback;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertUps.UpsAlertComponent;

public class UpsSender
extends AlertSender<UpsAlertComponent> {
    private final Log log = LogFactory.getLog(UpsSender.class);

    public UpsSender() {
        System.setProperty("jsse.enableSNIExtension", "false");
    }

    public SenderResult send(Alert alert) {
        StringBuilder b = new StringBuilder();
        b.append("Alert on");
        b.append(alert.getAlertDefinition().getResource().getName());
        b.append(":");
        b.append(((AlertConditionLog)alert.getConditionLogs().iterator().next()).getCondition().toString());
        b.append("Brought by RHQ");
        UnifiedMessage unifiedMessage = new UnifiedMessage.Builder().pushApplicationId(((UpsAlertComponent)this.pluginComponent).pushId).masterSecret(((UpsAlertComponent)this.pluginComponent).masterSecret).alert(b.toString()).sound("default").build();
        String rootServerURL = "https://" + ((UpsAlertComponent)this.pluginComponent).targetHost;
        if (((UpsAlertComponent)this.pluginComponent).port != 80) {
            rootServerURL = rootServerURL + ":" + ((UpsAlertComponent)this.pluginComponent).port;
        }
        SenderClient sender = new SenderClient(rootServerURL);
        final SenderResult[] result = new SenderResult[1];
        sender.send(unifiedMessage, new MessageResponseCallback(){

            public void onError(Throwable throwable) {
                result[0] = SenderResult.getSimpleFailure((String)throwable.getMessage());
            }

            public void onComplete(int statusCode) {
                result[0] = SenderResult.getSimpleSuccess((String)("Yieha! " + statusCode));
            }
        });
        return result[0];
    }
}

