/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.drift.mongodb.dao;

import com.google.code.morphia.Morphia;
import com.google.code.morphia.dao.BasicDAO;
import com.google.code.morphia.query.Query;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.DriftCriteria;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.CategoryFilter;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.ChangeSetEntryFilters;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.CreatedAfterFilter;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.CreatedBeforeFilter;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.DirectoryFilter;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.PathFilter;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBChangeSet;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBChangeSetEntry;

public class ChangeSetDAO
extends BasicDAO<MongoDBChangeSet, ObjectId> {
    private Morphia morphia;

    public ChangeSetDAO(Morphia morphia, Mongo mongo, String db) {
        super(mongo, morphia, db);
        this.morphia = morphia;
    }

    public List<MongoDBChangeSet> findByChangeSetCritiera(DriftChangeSetCriteria criteria) {
        Query query = this.createQuery();
        if (criteria.getFilterId() != null) {
            return ((Query)query.field("id").equal((Object)new ObjectId(criteria.getFilterId()))).asList();
        }
        if (criteria.getFilterResourceId() != null) {
            query.field("resourceId").equal((Object)criteria.getFilterResourceId());
        }
        if (criteria.getFilterDriftDefinitionId() != null) {
            query.field("driftDefId").equal((Object)criteria.getFilterDriftDefinitionId());
        }
        if (criteria.getFilterVersion() != null) {
            query.field("version").equal((Object)Integer.parseInt(criteria.getFilterVersion()));
        }
        if (criteria.getFilterStartVersion() != null) {
            query.field("version").greaterThanOrEq((Object)Integer.parseInt(criteria.getFilterStartVersion()));
        }
        if (criteria.getFilterEndVersion() != null) {
            query.field("version").lessThanOrEq((Object)Integer.parseInt(criteria.getFilterEndVersion()));
        }
        if (criteria.getFilterCreatedAfter() != null) {
            query.field("ctime").greaterThanOrEq((Object)criteria.getFilterCreatedAfter());
        }
        if (criteria.getFilterCreatedBefore() != null) {
            query.field("ctime").lessThan((Object)criteria.getFilterCreatedBefore());
        }
        if (criteria.getFilterDriftPath() != null) {
            query.field("files.path").equal((Object)Pattern.compile(".*" + criteria.getFilterDriftPath() + ".*"));
        }
        if (criteria.getFilterDriftDirectory() != null) {
            query.field("files.directory").equal((Object)criteria.getFilterDriftDirectory());
        }
        if (criteria.getFilterCategory() != null) {
            query.field("category").equal((Object)criteria.getFilterCategory());
        }
        if (criteria.getFilterDriftCategories() != null) {
            query.field("files.category").in((Iterable)criteria.getFilterDriftCategories());
        }
        if (!criteria.isFetchDrifts()) {
            query.retrievedFields(false, new String[]{"files"});
        }
        if (criteria.getSortVersion() != null) {
            if (criteria.getSortVersion() == PageOrdering.ASC) {
                query.order("version");
            } else {
                query.order("-version");
            }
        }
        return query.asList();
    }

    public List<MongoDBChangeSet> findByDriftCriteria(DriftCriteria criteria) {
        Query query = this.createQuery();
        if (criteria.getFilterId() != null) {
            String[] ids = criteria.getFilterId().split(":");
            ObjectId changeSetId = new ObjectId(ids[0]);
            query.field("id").equal((Object)changeSetId);
            return query.asList();
        }
        if (criteria.getFilterChangeSetId() != null && !criteria.getFilterChangeSetId().isEmpty()) {
            query.field("id").equal((Object)new ObjectId(criteria.getFilterChangeSetId()));
            return query.asList();
        }
        if (criteria.getFilterResourceIds() != null && criteria.getFilterResourceIds().length > 0) {
            query.field("resourceId").in(Arrays.asList(criteria.getFilterResourceIds()));
        }
        if (criteria.getFilterCategories() != null && criteria.getFilterCategories().length > 0) {
            query.field("files.category").in(Arrays.asList(criteria.getFilterCategories()));
        }
        if (criteria.getFilterStartTime() != null) {
            query.field("files.ctime").greaterThanOrEq((Object)criteria.getFilterStartTime());
        }
        if (criteria.getFilterEndTime() != null) {
            query.field("files.ctime").lessThanOrEq((Object)criteria.getFilterEndTime());
        }
        if (criteria.getFilterPath() != null && !criteria.getFilterPath().isEmpty()) {
            query.field("files.path").equal((Object)criteria.getFilterPath());
        }
        return query.asList();
    }

    public List<MongoDBChangeSetEntry> findEntries(DriftCriteria criteria) {
        if (criteria.getFilterId() != null) {
            String[] ids = criteria.getFilterId().split(":");
            ObjectId changeSetId = new ObjectId(ids[0]);
            return Arrays.asList(this.findEntryById(changeSetId, ids[1]));
        }
        Query query = this.createQuery();
        boolean changeSetsFiltered = false;
        boolean entriesFiltered = false;
        ChangeSetEntryFilters filters = new ChangeSetEntryFilters();
        if (criteria.getFilterChangeSetId() != null) {
            query.field("id").equal((Object)new ObjectId(criteria.getFilterChangeSetId()));
            changeSetsFiltered = true;
        }
        if (criteria.getFilterResourceIds().length > 0) {
            query.field("resourceId").in(Arrays.asList(criteria.getFilterResourceIds()));
            changeSetsFiltered = true;
        }
        if (criteria.getFilterDriftDefinitionId() != null) {
            query.field("driftDefId").equal((Object)criteria.getFilterDriftDefinitionId());
            changeSetsFiltered = true;
        }
        if (criteria.getFilterChangeSetStartVersion() != null) {
            query.field("version").greaterThanOrEq((Object)criteria.getFilterChangeSetStartVersion());
            changeSetsFiltered = true;
        }
        if (criteria.getFilterChangeSetEndVersion() != null) {
            query.field("version").lessThanOrEq((Object)criteria.getFilterChangeSetEndVersion());
            changeSetsFiltered = true;
        }
        if (criteria.getFilterCategories().length > 0) {
            query.field("files.category").in(Arrays.asList(criteria.getFilterCategories()));
            entriesFiltered = true;
            filters.add(new CategoryFilter(criteria.getFilterCategories()));
        }
        if (criteria.getFilterEndTime() != null) {
            query.field("files.ctime").lessThanOrEq((Object)criteria.getFilterEndTime());
            entriesFiltered = true;
            filters.add(new CreatedBeforeFilter(criteria.getFilterEndTime()));
        }
        if (criteria.getFilterStartTime() != null) {
            query.field("files.ctime").greaterThanOrEq((Object)criteria.getFilterStartTime());
            entriesFiltered = true;
            filters.add(new CreatedAfterFilter(criteria.getFilterStartTime()));
        }
        if (criteria.getFilterPath() != null && !criteria.getFilterPath().isEmpty()) {
            query.field("files.path").equal((Object)criteria.getFilterPath());
            entriesFiltered = true;
            filters.add(new PathFilter(criteria.getFilterPath()));
        }
        if (criteria.getFilterDirectory() != null) {
            query.field("files.directory").equal((Object)criteria.getFilterDirectory());
            entriesFiltered = true;
            filters.add(new DirectoryFilter(criteria.getFilterDirectory()));
        }
        ArrayList<MongoDBChangeSetEntry> entries = new ArrayList<MongoDBChangeSetEntry>();
        if (changeSetsFiltered && !entriesFiltered) {
            for (MongoDBChangeSet c : query.asList()) {
                entries.addAll(c.getDrifts());
            }
        } else {
            for (MongoDBChangeSet c : query.asList()) {
                for (MongoDBChangeSetEntry e : c.getDrifts()) {
                    if (!filters.matchesAll(e)) continue;
                    entries.add(e);
                }
            }
        }
        return entries;
    }

    public MongoDBChangeSetEntry findEntryById(ObjectId changeSetId, String entryId) {
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)changeSetId);
        BasicDBObject keys = new BasicDBObject();
        keys.put("files", (Object)new BasicDBObject().append("$slice", (Object)new Integer[]{Integer.valueOf(entryId), 1}));
        DBObject result = this.getCollection().findOne((DBObject)query, (DBObject)keys);
        if (result == null) {
            return null;
        }
        MongoDBChangeSet changeSet = (MongoDBChangeSet)this.morphia.fromDBObject(MongoDBChangeSet.class, result);
        if (!changeSet.getDrifts().isEmpty()) {
            return changeSet.getDrifts().iterator().next();
        }
        return null;
    }

    public void deleteChangeSets(int resourceId, String driftDefName) {
        this.deleteByQuery((Query)((Query)this.createQuery().field("resourceId").equal((Object)resourceId)).field("driftDefName").equal((Object)driftDefName));
    }
}

