/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.drift.mongodb.dao;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileDAO {
    private DB db;
    private GridFS gridFS;

    public FileDAO(DB db) {
        this.db = db;
        this.gridFS = new GridFS(this.db);
    }

    public GridFSDBFile findById(String hash) {
        return this.gridFS.findOne((DBObject)new BasicDBObject("_id", (Object)hash));
    }

    public InputStream findOne(String hash) {
        GridFSDBFile dbFile = this.gridFS.findOne((DBObject)new BasicDBObject("_id", (Object)hash));
        if (dbFile == null) {
            return null;
        }
        return dbFile.getInputStream();
    }

    public void save(File file) throws IOException {
        GridFSInputFile inputFile = this.gridFS.createFile((InputStream)new BufferedInputStream(new FileInputStream(file)));
        inputFile.put("_id", (Object)file.getName());
        inputFile.save();
    }

    public void delete(String id) {
        this.gridFS.remove((DBObject)new BasicDBObject("_id", (Object)id));
    }

    public DBCursor getFileListCursor() {
        return this.gridFS.getFileList();
    }
}

