/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.drift.mongodb.entities;

import com.google.code.morphia.annotations.Embedded;
import java.io.Serializable;
import org.rhq.core.domain.drift.DriftFile;
import org.rhq.core.domain.drift.DriftFileStatus;

@Embedded
public class MongoDBFile
implements Serializable,
DriftFile {
    private static final long serialVersionUID = 1L;
    private String hash;
    private Long ctime = System.currentTimeMillis();
    private Long size;
    private DriftFileStatus status;

    public MongoDBFile() {
    }

    public MongoDBFile(String hash) {
        this.hash = hash;
    }

    public MongoDBFile(DriftFile driftFile) {
        this.hash = driftFile.getHashId();
        this.size = driftFile.getDataSize();
    }

    public String getHashId() {
        return this.hash;
    }

    public void setHashId(String hashId) {
        this.hash = hashId;
    }

    public Long getCtime() {
        return this.ctime;
    }

    public Long getDataSize() {
        return this.size;
    }

    public void setDataSize(Long size) {
        this.size = size;
    }

    public DriftFileStatus getStatus() {
        return this.status;
    }

    public void setStatus(DriftFileStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDBFile that = (MongoDBFile)o;
        return !(this.hash != null ? !this.hash.equals(that.hash) : that.hash != null);
    }

    public int hashCode() {
        return this.hash != null ? this.hash.hashCode() : 0;
    }
}

