/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.embeddedagent.extension;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.rhq.embeddedagent.extension.AgentSubsystemDefinition;

public class AgentSubsystemExtension
implements Extension {
    private final Logger log = Logger.getLogger(AgentSubsystemExtension.class);
    public static final String NAMESPACE = "urn:org.rhq:embeddedagent:1.0";
    public static final String SUBSYSTEM_NAME = "embeddedagent";
    private final SubsystemParser parser = new SubsystemParser();
    private static final String RESOURCE_NAME = AgentSubsystemExtension.class.getPackage().getName() + ".LocalDescriptions";
    protected static final String PLUGINS_ELEMENT = "plugins";
    protected static final String PLUGIN_ELEMENT = "plugin";
    protected static final String PLUGIN_NAME = "name";
    protected static final String PLUGIN_ENABLED = "enabled";
    protected static final String AGENT_ENABLED = "enabled";
    protected static final boolean AGENT_ENABLED_DEFAULT = false;
    protected static final boolean PLUGIN_ENABLED_DEFAULT = true;
    protected static final String AGENT_CONFIG_ELEMENT = "extra-configuration";
    protected static final String PREFERENCE_ELEMENT = "preference";
    protected static final String SERVER_ENDPOINT_ELEMENT = "server-endpoint";
    protected static final String SERVER_ENDPOINT_ADDRESS_XML = "address";
    protected static final String SERVER_ENDPOINT_PORT_XML = "port";
    protected static final String SERVER_ENDPOINT_TRANSPORT_XML = "transport";
    protected static final String SERVER_ENDPOINT_TRANSPORT_PARAMS_XML = "transport-params";
    protected static final String AGENT_ENDPOINT_ELEMENT = "agent-endpoint";
    protected static final String AGENT_ENDPOINT_SOCKET_BINDING_XML = "socket-binding";
    protected static final String AGENT_ENDPOINT_TRANSPORT_XML = "transport";
    protected static final String AGENT_ENDPOINT_TRANSPORT_PARAMS_XML = "transport-params";
    protected static final String AGENT_RESTART_OP = "restart";
    protected static final String AGENT_STOP_OP = "stop";
    protected static final String AGENT_STATUS_OP = "status";
    protected static final String AGENT_EXECUTE_PROMPT_CMD_OP = "execute-prompt-command";
    protected static final String ATTRIB_AGENT_NAME = "rhq.agent.name";
    protected static final String ATTRIB_DISABLE_NATIVE = "rhq.agent.disable-native-system";
    protected static final String ATTRIB_SERVER_TRANSPORT = "rhq.agent.server.transport";
    protected static final String ATTRIB_SERVER_BIND_PORT = "rhq.agent.server.bind-port";
    protected static final String ATTRIB_SERVER_BIND_ADDRESS = "rhq.agent.server.bind-address";
    protected static final String ATTRIB_SERVER_TRANSPORT_PARAMS = "rhq.agent.server.transport-params";
    protected static final String ATTRIB_SERVER_ALIAS = "rhq.agent.server.alias";
    protected static final String ATTRIB_SOCKET_BINDING = "socket-binding";
    protected static final String ATTRIB_AGENT_TRANSPORT = "rhq.communications.connector.transport";
    protected static final String ATTRIB_AGENT_TRANSPORT_PARAMS = "rhq.communications.connector.transport-params";
    protected static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"embeddedagent");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, AgentSubsystemExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        this.log.info((Object)"Initializing embedded agent subsystem");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)AgentSubsystemDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)this.parser);
    }

    private static class SubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private SubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"enabled");
            ModelNode opAdd = new ModelNode();
            opAdd.get("operation").set("add");
            opAdd.get(AgentSubsystemExtension.SERVER_ENDPOINT_ADDRESS_XML).set(PathAddress.pathAddress((PathElement[])new PathElement[]{SUBSYSTEM_PATH}).toModelNode());
            String agentEnabledValue = reader.getAttributeValue(null, "enabled");
            if (agentEnabledValue != null) {
                opAdd.get("enabled").setExpression(agentEnabledValue);
            }
            while (reader.hasNext() && reader.nextTag() != 2) {
                String val;
                String elementName = reader.getLocalName();
                if (elementName.equals(AgentSubsystemExtension.PLUGINS_ELEMENT)) {
                    ModelNode pluginsAttributeNode = opAdd.get(AgentSubsystemExtension.PLUGINS_ELEMENT);
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        if (!reader.isStartElement()) continue;
                        this.readPlugin(reader, pluginsAttributeNode);
                    }
                    continue;
                }
                if (elementName.equals(AgentSubsystemExtension.AGENT_CONFIG_ELEMENT)) {
                    ModelNode configAttributeNode = opAdd.get(AgentSubsystemExtension.AGENT_CONFIG_ELEMENT);
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        if (!reader.isStartElement()) continue;
                        this.readPreference(reader, configAttributeNode);
                    }
                    continue;
                }
                if (elementName.equals(AgentSubsystemExtension.SERVER_ENDPOINT_ELEMENT)) {
                    val = reader.getAttributeValue(null, AgentSubsystemExtension.SERVER_ENDPOINT_ADDRESS_XML);
                    if (val != null) {
                        opAdd.get(AgentSubsystemExtension.ATTRIB_SERVER_BIND_ADDRESS).setExpression(val);
                    }
                    if ((val = reader.getAttributeValue(null, AgentSubsystemExtension.SERVER_ENDPOINT_PORT_XML)) != null) {
                        opAdd.get(AgentSubsystemExtension.ATTRIB_SERVER_BIND_PORT).setExpression(val);
                    }
                    if ((val = reader.getAttributeValue(null, "transport")) != null) {
                        opAdd.get(AgentSubsystemExtension.ATTRIB_SERVER_TRANSPORT).setExpression(val);
                    }
                    if ((val = reader.getAttributeValue(null, "transport-params")) != null) {
                        opAdd.get(AgentSubsystemExtension.ATTRIB_SERVER_TRANSPORT_PARAMS).setExpression(val);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue;
                }
                if (elementName.equals(AgentSubsystemExtension.AGENT_ENDPOINT_ELEMENT)) {
                    val = reader.getAttributeValue(null, "socket-binding");
                    if (val != null) {
                        opAdd.get("socket-binding").set(val);
                    }
                    if ((val = reader.getAttributeValue(null, "transport")) != null) {
                        opAdd.get(AgentSubsystemExtension.ATTRIB_AGENT_TRANSPORT).setExpression(val);
                    }
                    if ((val = reader.getAttributeValue(null, "transport-params")) != null) {
                        opAdd.get(AgentSubsystemExtension.ATTRIB_AGENT_TRANSPORT_PARAMS).setExpression(val);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue;
                }
                if (elementName.equals(AgentSubsystemExtension.ATTRIB_AGENT_NAME)) {
                    opAdd.get(AgentSubsystemExtension.ATTRIB_AGENT_NAME).setExpression(reader.getElementText());
                    continue;
                }
                if (elementName.equals(AgentSubsystemExtension.ATTRIB_DISABLE_NATIVE)) {
                    opAdd.get(AgentSubsystemExtension.ATTRIB_DISABLE_NATIVE).setExpression(reader.getElementText());
                    continue;
                }
                if (elementName.equals(AgentSubsystemExtension.ATTRIB_SERVER_ALIAS)) {
                    opAdd.get(AgentSubsystemExtension.ATTRIB_SERVER_ALIAS).setExpression(reader.getElementText());
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            list.add(opAdd);
        }

        private void readPlugin(XMLExtendedStreamReader reader, ModelNode pluginsAttributeNode) throws XMLStreamException {
            if (!reader.getLocalName().equals(AgentSubsystemExtension.PLUGIN_ELEMENT)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String pluginName = null;
            boolean pluginEnabled = true;
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attr = reader.getAttributeLocalName(i);
                String value = reader.getAttributeValue(i);
                if (attr.equals("enabled")) {
                    pluginEnabled = Boolean.parseBoolean(value);
                    continue;
                }
                if (attr.equals(AgentSubsystemExtension.PLUGIN_NAME)) {
                    pluginName = value;
                    continue;
                }
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (pluginName == null) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(AgentSubsystemExtension.PLUGIN_NAME));
            }
            pluginsAttributeNode.add(pluginName, pluginEnabled);
        }

        private void readPreference(XMLExtendedStreamReader reader, ModelNode configAttributeNode) throws XMLStreamException {
            if (!reader.getLocalName().equals(AgentSubsystemExtension.PREFERENCE_ELEMENT)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
            String attr = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
            String val = reader.getAttributeValue(null, Attribute.VALUE.getLocalName());
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            configAttributeNode.add(attr, val);
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            context.startSubsystemElement(AgentSubsystemExtension.NAMESPACE, false);
            writer.writeAttribute("enabled", node.get("enabled").asString());
            this.writeElement(writer, node, AgentSubsystemExtension.ATTRIB_AGENT_NAME);
            this.writeElement(writer, node, AgentSubsystemExtension.ATTRIB_DISABLE_NATIVE);
            this.writeElement(writer, node, AgentSubsystemExtension.ATTRIB_SERVER_ALIAS);
            writer.writeStartElement(AgentSubsystemExtension.SERVER_ENDPOINT_ELEMENT);
            ModelNode serverAddressNode = node.get(AgentSubsystemExtension.ATTRIB_SERVER_BIND_ADDRESS);
            ModelNode serverPortNode = node.get(AgentSubsystemExtension.ATTRIB_SERVER_BIND_PORT);
            ModelNode serverTransportNode = node.get(AgentSubsystemExtension.ATTRIB_SERVER_TRANSPORT);
            ModelNode serverTransportParamsNode = node.get(AgentSubsystemExtension.ATTRIB_SERVER_TRANSPORT_PARAMS);
            if (serverPortNode.isDefined()) {
                writer.writeAttribute(AgentSubsystemExtension.SERVER_ENDPOINT_PORT_XML, serverPortNode.asString());
            }
            if (serverAddressNode.isDefined()) {
                writer.writeAttribute(AgentSubsystemExtension.SERVER_ENDPOINT_ADDRESS_XML, serverAddressNode.asString());
            }
            if (serverTransportNode.isDefined()) {
                writer.writeAttribute("transport", serverTransportNode.asString());
            }
            if (serverTransportParamsNode.isDefined()) {
                writer.writeAttribute("transport-params", serverTransportParamsNode.asString());
            }
            writer.writeEndElement();
            writer.writeStartElement(AgentSubsystemExtension.AGENT_ENDPOINT_ELEMENT);
            ModelNode agentSocketBindingNode = node.get("socket-binding");
            ModelNode agentTransportNode = node.get(AgentSubsystemExtension.ATTRIB_AGENT_TRANSPORT);
            ModelNode agentTransportParamsNode = node.get(AgentSubsystemExtension.ATTRIB_AGENT_TRANSPORT_PARAMS);
            if (agentSocketBindingNode.isDefined()) {
                writer.writeAttribute("socket-binding", agentSocketBindingNode.asString());
            }
            if (agentTransportNode.isDefined()) {
                writer.writeAttribute("transport", agentTransportNode.asString());
            }
            if (agentTransportParamsNode.isDefined()) {
                writer.writeAttribute("transport-params", agentTransportParamsNode.asString());
            }
            writer.writeEndElement();
            writer.writeStartElement(AgentSubsystemExtension.AGENT_CONFIG_ELEMENT);
            ModelNode configNode = node.get(AgentSubsystemExtension.AGENT_CONFIG_ELEMENT);
            if (configNode != null && configNode.isDefined()) {
                for (Property property : configNode.asPropertyList()) {
                    writer.writeStartElement(AgentSubsystemExtension.PREFERENCE_ELEMENT);
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), property.getValue().asString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.writeStartElement(AgentSubsystemExtension.PLUGINS_ELEMENT);
            ModelNode plugins = node.get(AgentSubsystemExtension.PLUGINS_ELEMENT);
            if (plugins != null && plugins.isDefined()) {
                for (Property property : plugins.asPropertyList()) {
                    writer.writeStartElement(AgentSubsystemExtension.PLUGIN_ELEMENT);
                    writer.writeAttribute(AgentSubsystemExtension.PLUGIN_NAME, property.getName());
                    writer.writeAttribute("enabled", property.getValue().asString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeElement(XMLExtendedStreamWriter writer, ModelNode node, String attribName) throws XMLStreamException {
            ModelNode attribNode = node.get(attribName);
            if (attribNode.isDefined()) {
                writer.writeStartElement(attribName);
                writer.writeCharacters(attribNode.asString());
                writer.writeEndElement();
            }
        }
    }
}

