/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.event.log.Log4JLogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileEventPoller;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.hadoop.HadoopOperationsDelegate;
import org.rhq.plugins.hadoop.HadoopServerConfigurationDelegate;
import org.rhq.plugins.hadoop.HadoopSupportedOperations;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.JMXServerComponent;

public class HadoopServerComponent
extends JMXServerComponent<ResourceComponent<?>>
implements JMXComponent<ResourceComponent<?>>,
MeasurementFacet,
OperationFacet,
ConfigurationFacet {
    private static final Log LOG = LogFactory.getLog(HadoopServerComponent.class);
    public static final String LOG_EVENT_TYPE = "logEntry";
    public static final String LOG_POLLING_INTERVAL_PROPERTY = "logPollingInterval";
    private Map<String, Boolean> percentageMeasurements;
    private HadoopServerConfigurationDelegate configurationDelegate;
    private HadoopOperationsDelegate operationsDelegate;
    private boolean eventsRegistered;

    public void start(ResourceContext context) throws Exception {
        super.start(context);
        this.configurationDelegate = new HadoopServerConfigurationDelegate(context);
        this.operationsDelegate = new HadoopOperationsDelegate(context);
        Set measDefinitions = context.getResourceType().getMetricDefinitions();
        this.percentageMeasurements = new HashMap<String, Boolean>(measDefinitions.size());
        for (MeasurementDefinition measDefinition : measDefinitions) {
            this.percentageMeasurements.put(measDefinition.getName(), MeasurementUnits.PERCENTAGE.equals((Object)measDefinition.getUnits()));
        }
    }

    public void stop() {
        EventContext events = this.getResourceContext().getEventContext();
        if (events != null && this.eventsRegistered) {
            this.eventsRegistered = false;
            events.unregisterEventPoller(LOG_EVENT_TYPE);
            this.discardPoller();
        }
        super.stop();
    }

    public AvailabilityType getAvailability() {
        ProcessInfo process = this.getResourceContext().getNativeProcess();
        AvailabilityType ret = process == null ? AvailabilityType.DOWN : (process.priorSnaphot().isRunning() ? AvailabilityType.UP : AvailabilityType.DOWN);
        EventContext events = this.getResourceContext().getEventContext();
        if (events != null) {
            if (ret == AvailabilityType.UP) {
                if (!this.eventsRegistered) {
                    File logFile = this.determineLogFile();
                    int interval = Integer.parseInt(this.getResourceContext().getPluginConfiguration().getSimpleValue(LOG_POLLING_INTERVAL_PROPERTY, "60"));
                    events.registerEventPoller(this.createNewEventPoller(events, logFile), interval);
                    this.eventsRegistered = true;
                }
            } else if (this.eventsRegistered) {
                this.eventsRegistered = false;
                events.unregisterEventPoller(LOG_EVENT_TYPE);
                this.discardPoller();
            }
        }
        return ret;
    }

    public EmsConnection getEmsConnection() {
        EmsConnection conn = super.getEmsConnection();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("EmsConnection is " + conn.toString()));
        }
        return conn;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest request : metrics) {
            this.handleMetric(report, request);
        }
    }

    protected void handleMetric(MeasurementReport report, MeasurementScheduleRequest request) throws Exception {
        String name = request.getName();
        int delimIndex = name.lastIndexOf(58);
        String beanName = name.substring(0, delimIndex);
        String attributeName = name.substring(delimIndex + 1);
        try {
            EmsConnection emsConnection = this.getEmsConnection();
            EmsBean bean = emsConnection.getBean(beanName);
            if (bean != null) {
                bean.refreshAttributes();
                EmsAttribute attribute = bean.getAttribute(attributeName);
                if (attribute != null) {
                    Object valueObject = attribute.refresh();
                    if (valueObject instanceof Number) {
                        Number value = (Number)valueObject;
                        if (this.percentageMeasurements.get(name).booleanValue()) {
                            report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue() / 100.0)));
                        } else {
                            report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
                        }
                    } else {
                        report.addData(new MeasurementDataTrait(request, valueObject.toString()));
                    }
                } else {
                    LOG.warn((Object)("Attribute " + attributeName + " not found"));
                }
            } else {
                LOG.warn((Object)("MBean " + beanName + " not found"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to obtain measurement [" + name + "]"), (Throwable)e);
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        return this.configurationDelegate.loadConfiguration();
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            Configuration updatedConfiguration = report.getConfiguration();
            this.configurationDelegate.updateConfiguration(updatedConfiguration);
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        HadoopSupportedOperations operation = HadoopSupportedOperations.valueOf(name.toUpperCase());
        String serverType = this.getServerType();
        OperationResult result = this.operationsDelegate.invoke(operation, params, serverType);
        if (operation.equals((Object)HadoopSupportedOperations.START) || operation.equals((Object)HadoopSupportedOperations.STOP)) {
            this.getResourceContext().getAvailabilityContext().requestAvailabilityCheck();
        }
        return result;
    }

    protected EventPoller createNewEventPoller(EventContext eventContext, File logFile) {
        return new LogFileEventPoller(eventContext, LOG_EVENT_TYPE, logFile, (LogEntryProcessor)new Log4JLogEntryProcessor(LOG_EVENT_TYPE, logFile));
    }

    protected void discardPoller() {
    }

    private File determineLogFile() {
        String username = this.getResourceContext().getNativeProcess().getCredentialsName().getUser();
        String hostname = this.getResourceContext().getSystemInformation().getHostname();
        String serverType = this.getServerType();
        String name = "hadoop-" + username + "-" + serverType + "-" + hostname + ".log";
        return new File(new File(this.getHomeDir(), "logs"), name);
    }

    private String getServerType() {
        String mainClass = this.getResourceContext().getPluginConfiguration().getSimpleValue("_mainClass");
        int dot = mainClass.lastIndexOf(46);
        String className = mainClass.substring(dot + 1);
        return className.toLowerCase();
    }

    protected File getHomeDir() {
        File homeDir = new File(this.getResourceContext().getPluginConfiguration().getSimpleValue("hadoop.home.dir"));
        if (!homeDir.exists()) {
            throw new IllegalArgumentException("The configured home directory of this Hadoop instance (" + homeDir.getAbsolutePath() + ") no longer exists.");
        }
        if (!homeDir.isDirectory()) {
            throw new IllegalArgumentException("The configured home directory of this Hadoop instance (" + homeDir.getAbsolutePath() + ") is not a directory.");
        }
        if (!homeDir.canRead()) {
            throw new IllegalArgumentException("The configured home directory of this Hadoop instance (" + homeDir.getAbsolutePath() + ") is not readable.");
        }
        return homeDir;
    }
}

