/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop.calltime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.rhq.core.domain.event.Event;
import org.rhq.core.pluginapi.event.log.Log4JLogEntryProcessor;
import org.rhq.core.pluginapi.event.log.MultiLineLogEntryProcessor;
import org.rhq.plugins.hadoop.calltime.JobSummary;

public class HadoopEventAndCalltimeDelegate
extends Log4JLogEntryProcessor {
    private Set<JobSummary> accumulatedJobEntries = new HashSet<JobSummary>();

    public HadoopEventAndCalltimeDelegate(String eventType, File logFile) {
        super(eventType, logFile);
    }

    public synchronized Set<JobSummary> drainAccumulatedJobs() {
        HashSet<JobSummary> ret = new HashSet<JobSummary>(this.accumulatedJobEntries);
        this.accumulatedJobEntries.clear();
        return ret;
    }

    public synchronized Set<Event> processLines(BufferedReader bufferedReader) throws IOException {
        return super.processLines(bufferedReader);
    }

    protected MultiLineLogEntryProcessor.LogEntry processPrimaryLine(Matcher matcher) throws MultiLineLogEntryProcessor.ParseException {
        JobSummary summary;
        MultiLineLogEntryProcessor.LogEntry logEntry = super.processPrimaryLine(matcher);
        String detail = matcher.group(3);
        if (detail.startsWith("org.apache.hadoop.mapred.JobInProgress$JobSummary") && (summary = JobSummary.parseJobSummaryLogEntry(matcher.group())) != null) {
            this.accumulatedJobEntries.add(summary);
        }
        return logEntry;
    }
}

