/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.file.FileUtil;

public class HadoopServerConfigurationDelegate {
    private static final Log LOG = LogFactory.getLog(HadoopServerConfigurationDelegate.class);
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String CONFIGURATION_TAG_NAME = "configuration";
    private static final String PROPERTY_TAG_NAME = "property";
    private static final String NAME_TAG_NAME = "name";
    private static final String VALUE_TAG_NAME = "value";
    private static final Pattern PROPERTY_NAME_EXTRACT_PATTERN = Pattern.compile("<name>(.*)<\\/name>");
    private static final Pattern PROPERTY_VALUE_REPLACE_PATTERN = Pattern.compile("<value>.*<\\/value>");
    private ResourceContext<ResourceComponent<?>> componentContext;

    public HadoopServerConfigurationDelegate(ResourceContext<ResourceComponent<?>> componentContext) {
        this.componentContext = componentContext;
    }

    public Configuration loadConfiguration() throws Exception {
        ConfigurationDefinition definition = this.componentContext.getResourceType().getResourceConfigurationDefinition();
        Configuration config = new Configuration();
        File homeDir = this.getHomeDir();
        HadoopServerConfigurationDelegate.fillResourceConfiguration(homeDir, config, definition);
        return config;
    }

    public void updateConfiguration(Configuration config) throws Exception {
        PropertiesPerConfigFileBuilder bld = new PropertiesPerConfigFileBuilder(this.getHomeDir());
        for (Property property : config.getProperties()) {
            if (!(property instanceof PropertySimple)) continue;
            PropertySimple property2 = (PropertySimple)property;
            bld.addProperty(property2);
        }
        for (Map.Entry entry : bld.getPropertiesPerFilePerConfigName().entrySet()) {
            HadoopServerConfigurationDelegate.updateFile((File)entry.getKey(), (Map)entry.getValue());
        }
    }

    private File getHomeDir() {
        File homeDir = new File(this.componentContext.getPluginConfiguration().getSimpleValue("hadoop.home.dir"));
        if (!homeDir.exists()) {
            throw new IllegalArgumentException("The configured home directory of this Hadoop instance (" + homeDir.getAbsolutePath() + ") no longer exists.");
        }
        if (!homeDir.isDirectory()) {
            throw new IllegalArgumentException("The configured home directory of this Hadoop instance (" + homeDir.getAbsolutePath() + ") is not a directory.");
        }
        if (!homeDir.canRead()) {
            throw new IllegalArgumentException("The configured home directory of this Hadoop instance (" + homeDir.getAbsolutePath() + ") is not readable.");
        }
        return homeDir;
    }

    public static void fillResourceConfiguration(File homeDir, Configuration config, ConfigurationDefinition definition) throws XMLStreamException, IOException {
        PropertiesPerConfigFileBuilder bld = new PropertiesPerConfigFileBuilder(homeDir);
        for (PropertyDefinition propertyDefinition : definition.getPropertyDefinitions().values()) {
            if (!(propertyDefinition instanceof PropertyDefinitionSimple)) continue;
            String propertyName = propertyDefinition.getName();
            bld.addProperty(propertyName, config);
        }
        for (Map.Entry entry : bld.getPropertiesPerFilePerConfigName().entrySet()) {
            File configFile = (File)entry.getKey();
            Map propertiesToFind = (Map)entry.getValue();
            HadoopServerConfigurationDelegate.parseAndAssignProps(configFile, propertiesToFind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseAndAssignProps(File configFile, Map<String, PropertySimple> props) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(configFile);
        XMLStreamReader rdr = XML_INPUT_FACTORY.createXMLStreamReader(in);
        try {
            boolean inProperty = false;
            String propertyName = null;
            String propertyValue = null;
            while (rdr.hasNext()) {
                int event = rdr.next();
                String tag = null;
                switch (event) {
                    case 1: {
                        tag = rdr.getName().getLocalPart();
                        if (PROPERTY_TAG_NAME.equals(tag)) {
                            inProperty = true;
                            break;
                        }
                        if (inProperty && NAME_TAG_NAME.equals(tag)) {
                            propertyName = rdr.getElementText();
                            break;
                        }
                        if (!inProperty || !VALUE_TAG_NAME.equals(tag)) break;
                        propertyValue = rdr.getElementText();
                        break;
                    }
                    case 2: {
                        tag = rdr.getName().getLocalPart();
                        if (!PROPERTY_TAG_NAME.equals(tag)) break;
                        inProperty = false;
                        PropertySimple prop = props.get(propertyName);
                        if (prop != null) {
                            prop.setValue((Object)propertyValue);
                        }
                        propertyName = null;
                        propertyValue = null;
                    }
                }
            }
        }
        finally {
            rdr.close();
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFile(File configFile, Map<String, PropertySimple> allProps) throws IOException, InterruptedException, XMLStreamException {
        InputStream in = null;
        XMLStreamReader rdr = null;
        OutputStream out = null;
        XMLStreamWriter outWrt = null;
        try {
            HashSet<String> processedPropertyNames = new HashSet<String>();
            in = new BufferedInputStream(new FileInputStream(configFile));
            rdr = XML_INPUT_FACTORY.createXMLStreamReader(in);
            File tmpFile = File.createTempFile("hadoop-plugin", null);
            out = new FileOutputStream(tmpFile);
            outWrt = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            ByteArrayOutputStream stash = new ByteArrayOutputStream();
            XMLStreamWriter stashWrt = XML_OUTPUT_FACTORY.createXMLStreamWriter(stash);
            boolean outputActive = true;
            outWrt.writeStartDocument();
            block25: while (rdr.hasNext()) {
                int event = rdr.next();
                XMLStreamWriter wrt = outputActive ? outWrt : stashWrt;
                switch (event) {
                    case 10: {
                        break;
                    }
                    case 12: {
                        wrt.writeCData(rdr.getText());
                        break;
                    }
                    case 4: {
                        wrt.writeCharacters(rdr.getText());
                        break;
                    }
                    case 5: {
                        wrt.writeComment(rdr.getText());
                        break;
                    }
                    case 11: {
                        wrt.writeDTD(rdr.getText());
                        break;
                    }
                    case 8: {
                        wrt.writeEndDocument();
                        break;
                    }
                    case 2: {
                        if (PROPERTY_TAG_NAME.equals(rdr.getName().getLocalPart())) {
                            String encoding = rdr.getEncoding();
                            if (encoding == null) {
                                encoding = "UTF-8";
                            }
                            String string = Charset.forName(encoding).decode(ByteBuffer.wrap(stash.toByteArray())).toString();
                            DetectedPropertyNameAndUpdatedTag propAndTag = HadoopServerConfigurationDelegate.updateProperty(string, allProps);
                            outWrt.flush();
                            out.write(propAndTag.updatedTag.getBytes("UTF-8"));
                            processedPropertyNames.add(propAndTag.propertyName);
                            stash.reset();
                            wrt = outWrt;
                            outputActive = true;
                        } else if (CONFIGURATION_TAG_NAME.equals(rdr.getName().getLocalPart())) {
                            for (String string : processedPropertyNames) {
                                allProps.remove(string);
                            }
                            for (Map.Entry entry : allProps.entrySet()) {
                                outWrt.writeStartElement(PROPERTY_TAG_NAME);
                                outWrt.writeStartElement(NAME_TAG_NAME);
                                outWrt.writeCharacters((String)entry.getKey());
                                outWrt.writeEndElement();
                                outWrt.writeStartElement(VALUE_TAG_NAME);
                                outWrt.writeCharacters(((PropertySimple)entry.getValue()).getStringValue());
                                outWrt.writeEndElement();
                                outWrt.writeEndElement();
                            }
                        }
                        wrt.writeEndElement();
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 9: {
                        wrt.writeEntityRef(rdr.getText());
                        break;
                    }
                    case 13: {
                        for (int i = 0; i < rdr.getNamespaceCount(); ++i) {
                            wrt.writeNamespace(rdr.getNamespacePrefix(i), rdr.getNamespaceURI(i));
                        }
                        continue block25;
                    }
                    case 14: {
                        break;
                    }
                    case 3: {
                        wrt.writeProcessingInstruction(rdr.getPITarget(), rdr.getPIData());
                        break;
                    }
                    case 6: {
                        wrt.writeCharacters(rdr.getText());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        wrt.writeStartElement(rdr.getName().getPrefix(), rdr.getName().getLocalPart(), rdr.getName().getNamespaceURI());
                        for (int i = 0; i < rdr.getAttributeCount(); ++i) {
                            wrt.writeAttribute(rdr.getAttributePrefix(i), rdr.getAttributeNamespace(i), rdr.getAttributeLocalName(i), rdr.getAttributeValue(i));
                        }
                        if (!PROPERTY_TAG_NAME.equals(rdr.getName().getLocalPart())) break;
                        wrt.writeCharacters("");
                        outputActive = false;
                    }
                }
            }
            outWrt.flush();
            out.flush();
            out.close();
            in.close();
            FileUtil.copyFile((File)tmpFile, (File)configFile);
        }
        finally {
            rdr.close();
            outWrt.flush();
            outWrt.close();
            try {
                in.close();
            }
            finally {
                out.flush();
                out.close();
            }
        }
    }

    private static DetectedPropertyNameAndUpdatedTag updateProperty(String propertyTag, Map<String, PropertySimple> allProps) {
        String propertyName;
        DetectedPropertyNameAndUpdatedTag ret = new DetectedPropertyNameAndUpdatedTag();
        ret.updatedTag = propertyTag;
        Matcher propertyNameMatcher = PROPERTY_NAME_EXTRACT_PATTERN.matcher(propertyTag);
        if (!propertyNameMatcher.find()) {
            return ret;
        }
        ret.propertyName = propertyName = propertyNameMatcher.group(1);
        if (propertyName == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Possibly invalid property tag?\n" + propertyTag));
            }
            return ret;
        }
        PropertySimple prop = allProps.get(propertyName);
        if (prop == null) {
            return ret;
        }
        if (prop.getStringValue() == null) {
            ret.updatedTag = "";
            return ret;
        }
        Matcher propertyValueMatcher = PROPERTY_VALUE_REPLACE_PATTERN.matcher(propertyTag);
        if (!propertyValueMatcher.find()) {
            return ret;
        }
        ret.updatedTag = propertyValueMatcher.replaceAll("<value>" + prop.getStringValue() + "</value>");
        return ret;
    }

    private static class PropertiesPerConfigFileBuilder {
        private Map<File, Map<String, PropertySimple>> propertiesPerFile = new HashMap<File, Map<String, PropertySimple>>();
        private File homeDir;

        public PropertiesPerConfigFileBuilder(File homeDir) {
            this.homeDir = homeDir;
        }

        void addProperty(String name, Configuration parentConfig) {
            PropertySimple ret = new PropertySimple();
            ret.setName(name);
            parentConfig.put((Property)ret);
            this.addProperty(ret);
        }

        void addProperty(PropertySimple property) {
            ConfigFileAndConfigName fn = new ConfigFileAndConfigName(this.homeDir, property.getName());
            Map<String, PropertySimple> props = this.propertiesPerFile.get(fn.configFile);
            if (props == null) {
                props = new HashMap<String, PropertySimple>();
                this.propertiesPerFile.put(fn.configFile, props);
            }
            props.put(fn.propertyName, property);
        }

        Map<File, Map<String, PropertySimple>> getPropertiesPerFilePerConfigName() {
            return this.propertiesPerFile;
        }

        private static class ConfigFileAndConfigName {
            File configFile;
            String propertyName;

            ConfigFileAndConfigName(File homeDir, String propertyDefinitionName) {
                String[] parts = propertyDefinitionName.split(":");
                String configFileName = parts[0];
                this.configFile = new File(homeDir, configFileName);
                this.propertyName = parts[1];
                if (!this.configFile.exists()) {
                    throw new IllegalArgumentException("The expected configuration file (" + this.configFile.getAbsolutePath() + ") doesn't exist.");
                }
            }
        }
    }

    private static class DetectedPropertyNameAndUpdatedTag {
        String propertyName;
        String updatedTag;

        private DetectedPropertyNameAndUpdatedTag() {
        }
    }
}

