/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.JMXServerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopServiceComponent
extends JMXServerComponent
implements JMXComponent,
ResourceComponent,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ResourceContext context;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        Configuration conf = context.getPluginConfiguration();
        this.context = context;
        super.start(context);
        this.log.info((Object)("Started " + context.getResourceKey()));
    }

    public void stop() {
        super.stop();
    }

    public EmsConnection getEmsConnection() {
        EmsConnection conn = super.getEmsConnection();
        this.log.info((Object)("EmsConnection is " + conn.toString()));
        return conn;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            String property = req.getName();
            String[] props = property.split("\\|");
            EmsConnection conn = this.getEmsConnection();
            EmsBean bean = conn.getBean(props[0]);
            if (bean != null) {
                bean.refreshAttributes();
                EmsAttribute att = bean.getAttribute(props[1]);
                if (att != null) {
                    Long val = (Long)att.getValue();
                    MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(val.longValue()));
                    report.addData(res);
                    continue;
                }
                this.log.warn((Object)("Attribute " + props[1] + " not found"));
                continue;
            }
            this.log.warn((Object)("MBean " + props[0] + " not found"));
        }
    }

    public void startOperationFacet(OperationContext context) {
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        OperationResult res = new OperationResult();
        if ("dummyOperation".equals(name)) {
            // empty if block
        }
        return res;
    }
}

