/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.support.metadata.LocalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopServiceDiscovery
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog(HadoopServiceDiscovery.class);
    private static final String HADOOP_VERSION_MATCH = ".*hadoop-([0-9\\.]+)-core.jar.*";
    private Pattern hadoopPattern = Pattern.compile(".*hadoop-([0-9\\.]+)-core.jar.*");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        List parentProcessScans = resourceDiscoveryContext.getParentResourceContext().getNativeProcessesForType();
        ResourceType resourceType = resourceDiscoveryContext.getResourceType();
        String rtName = resourceType.getName();
        for (ProcessScanResult psr : parentProcessScans) {
            if (!psr.getProcessScan().getName().equals(rtName)) continue;
            String[] commandLineArgs = psr.getProcessInfo().getCommandLine();
            String version = this.getVersion(commandLineArgs);
            String javaClazz = this.getClazzFromCommandLine(commandLineArgs);
            Configuration pluginConfiguration = resourceDiscoveryContext.getDefaultPluginConfiguration();
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceType, rtName + ":" + psr.getProcessInfo().getCurrentWorkingDirectory(), rtName, version, "Hadoop " + rtName + " ( " + psr.getProcessInfo().getCurrentWorkingDirectory() + " )", pluginConfiguration, psr.getProcessInfo());
            pluginConfiguration.put((Property)new PropertySimple("commandLine", (Object)javaClazz));
            pluginConfiguration.put((Property)new PropertySimple("type", (Object)LocalVMTypeDescriptor.class.getName()));
            this.log.info((Object)("Discovered " + detail));
            details.add(detail);
        }
        return details;
    }

    private String getClazzFromCommandLine(String[] commandLineArgs) {
        for (String line : commandLineArgs) {
            if (!line.startsWith("org.apache.hadoop.")) continue;
            return line;
        }
        return "-not found-";
    }

    private String getVersion(String[] commandLine) {
        for (String line : commandLine) {
            Matcher m = this.hadoopPattern.matcher(line);
            if (!m.matches()) continue;
            String result = m.group(1);
            return result;
        }
        return null;
    }
}

