/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

public enum HadoopSupportedOperations {
    FORMAT(true, "/bin/hadoop", "namenode -format", new String[0]),
    FSCK(true, "/bin/hadoop", "fsck /", new String[0]),
    LS(true, "/bin/hadoop", "fs -ls", new String[0]),
    START(true, "/bin/hadoop-daemon.sh", "start ", new String[0]),
    STOP(true, "/bin/hadoop-daemon.sh", "stop ", new String[0]),
    QUEUE_LIST(true, "/bin/hadoop", "queue -list", new String[0]),
    JOB_LIST_RUNNING(true, "/bin/hadoop", "job -list", new String[0]),
    JOB_LIST_ALL(true, "/bin/hadoop", "job -list all", new String[0]),
    REBALANCE_DFS(true, "/bin/hadoop", "balancer", new String[0]),
    KILL(true, "/bin/hadoop", "job -kill", "pid"),
    JAR(false, "/bin/hadoop", "jar", "args");

    private final String relativePathToExecutable;
    private final String args;
    private final String[] paramNames;
    private final boolean killOnTimeout;

    private HadoopSupportedOperations(boolean killOnTimeout, String relativePathToExecutable, String args, String ... paramNames) {
        this.killOnTimeout = killOnTimeout;
        this.relativePathToExecutable = relativePathToExecutable;
        this.args = args;
        this.paramNames = paramNames;
    }

    public String getRelativePathToExecutable() {
        return this.relativePathToExecutable;
    }

    public String getArgs() {
        return this.args;
    }

    public String[] getParamsNames() {
        return this.paramNames;
    }

    public boolean isKillOnTimeout() {
        return this.killOnTimeout;
    }
}

