/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.hadoop.JobTrackerServerComponent;

public class JobJarDiscoveryComponent
implements ResourceDiscoveryComponent<JobTrackerServerComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JobTrackerServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        File dataDir = ((JobTrackerServerComponent)context.getParentResourceComponent()).getJobJarDataDir();
        File[] jars = dataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        HashSet<DiscoveredResourceDetails> ret = new HashSet<DiscoveredResourceDetails>();
        for (File jar : jars) {
            DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), jar.getAbsolutePath(), jar.getName(), null, null, context.getDefaultPluginConfiguration(), null);
            ret.add(details);
        }
        return ret;
    }
}

