/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop.calltime;

import java.io.Serializable;

public class JobSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXPECTED_LOGGER = "org.apache.hadoop.mapred.JobInProgress$JobSummary";
    private String jobId;
    private String jobName;
    private long startTime;
    private long endTime;
    private long submitTime;
    private int mapTasks;
    private int reduceTasks;
    private boolean succeeded;

    public static JobSummary parseJobSummaryLogEntry(String logEntry) {
        String[] props;
        JobSummary ret = new JobSummary();
        int loggerIdx = logEntry.indexOf(EXPECTED_LOGGER);
        if (loggerIdx < 0) {
            return null;
        }
        for (String prop : props = logEntry.substring(loggerIdx += EXPECTED_LOGGER.length() + 2).split(",")) {
            String[] keyValue = prop.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            if ("jobId".equals(key)) {
                ret.setJobId(value);
                continue;
            }
            if ("submitTime".equals(key)) {
                ret.setSubmitTime(Long.parseLong(value));
                continue;
            }
            if ("launchTime".equals(key)) {
                ret.setStartTime(Long.parseLong(value));
                continue;
            }
            if ("finishTime".equals(key)) {
                ret.setEndTime(Long.parseLong(value));
                continue;
            }
            if ("numMaps".equals(key)) {
                ret.setMapTasks(Integer.parseInt(value));
                continue;
            }
            if ("numReduces".equals(key)) {
                ret.setReduceTasks(Integer.parseInt(value));
                continue;
            }
            if ("status".equals(key)) {
                ret.setSucceeded("SUCCEEDED".equals(value));
                continue;
            }
            if (!"jobName".equals(key)) continue;
            ret.setJobName(value);
        }
        return ret;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getMapTasks() {
        return this.mapTasks;
    }

    public void setMapTasks(int mapTasks) {
        this.mapTasks = mapTasks;
    }

    public int getReduceTasks() {
        return this.reduceTasks;
    }

    public void setReduceTasks(int reduceTasks) {
        this.reduceTasks = reduceTasks;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(long submitTime) {
        this.submitTime = submitTime;
    }

    public int hashCode() {
        return this.jobId == null ? 0 : this.jobId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary)o;
        return this.getJobId() == null ? other.getJobId() == null : this.getJobId().equals(other.getJobId());
    }
}

