/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.alertMigration;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alert13Parser {
    private final Log log = LogFactory.getLog(Alert13Parser.class);
    File inputFile;
    Reader inputReader;
    public static final String RHQ_USERS = "RHQ Users";

    public Alert13Parser(File input) {
        this.inputFile = input;
        try {
            this.inputReader = new FileReader(input);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File " + input.getAbsolutePath() + " not found");
        }
    }

    public Alert13Parser(Reader reader) {
        this.inputReader = reader;
    }

    public Alert13Parser(InputStream stream) {
        this.inputReader = new InputStreamReader(stream);
    }

    public List<AlertNotification> parse() {
        ArrayList<AlertNotification> result = new ArrayList<AlertNotification>();
        List lines = null;
        try {
            CSVReader reader = new CSVReader(this.inputReader);
            lines = reader.readAll();
            reader.close();
            boolean isFirst = true;
            for (String[] line : lines) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                if (line.length < 2) continue;
                this.log.debug(Arrays.asList(line));
                String tmp = line[9];
                int alertDefinitionId = Integer.valueOf(tmp);
                this.log.debug((Object)("  adefid " + alertDefinitionId));
                tmp = line[1];
                CSVReader nr = new CSVReader((Reader)new StringReader(tmp));
                String[] notifications = nr.readNext();
                int i = 0;
                int pos = 0;
                while (i < notifications.length) {
                    String n = notifications[i];
                    this.log.debug((Object)("   Notification: " + n));
                    if (n.startsWith("[") || n.startsWith(" ")) {
                        n = n.substring(1);
                    }
                    if (n.equals("]")) {
                        ++i;
                        continue;
                    }
                    int nid = Integer.valueOf(this.getField(n, "id"));
                    AlertNotification alNo = new AlertNotification(alertDefinitionId, nid);
                    Configuration config = new Configuration();
                    alNo.setConfiguration(config);
                    alNo.setOrder(pos);
                    if (n.startsWith("Subject")) {
                        String subjectId = this.getField(notifications[i + 1], "id");
                        String subject = this.getField(notifications[i + 2], "name");
                        i += 4;
                        this.log.debug((Object)("subject: " + subjectId));
                        config.put((Property)new PropertySimple("subjectId", (Object)subjectId));
                        alNo.setSenderName(RHQ_USERS);
                        alNo.setName(subject);
                    } else if (n.startsWith("Role")) {
                        String roleId = this.getField(notifications[i + 1], "id");
                        String role = this.getField(notifications[i + 2], "name");
                        i += 4;
                        this.log.debug((Object)("role: " + roleId));
                        config.put((Property)new PropertySimple("roleId", (Object)roleId));
                        alNo.setSenderName("Roles");
                        alNo.setName(role);
                    } else if (n.startsWith("Snmp")) {
                        String host = this.getField(notifications[i + 1], "host");
                        String port = this.getField(notifications[i + 2], "port");
                        String oid = this.getField(notifications[i + 3], "oid");
                        i += 5;
                        this.log.debug((Object)("snmp: " + host + ", " + port + ", " + oid));
                        config.put((Property)new PropertySimple("host", (Object)host));
                        config.put((Property)new PropertySimple("port", (Object)port));
                        config.put((Property)new PropertySimple("OID", (Object)oid));
                        alNo.setSenderName("SNMP");
                        alNo.setName(host + oid);
                    } else if (n.startsWith("Email")) {
                        String emails = this.getField(notifications[i + 1], "emailAddress");
                        this.log.debug((Object)("email: " + emails));
                        config.put((Property)new PropertySimple("emailAddress", (Object)emails));
                        alNo.setSenderName("Email");
                        alNo.setName(emails);
                        i += 3;
                    } else {
                        this.log.error((Object)("Unknown notification :>" + n + "<"));
                        ++i;
                    }
                    this.log.debug((Object)(" -- for nid : " + nid));
                    result.add(alNo);
                    ++pos;
                }
                tmp = line[12];
                nr = new CSVReader((Reader)new StringReader(tmp));
                String[] operations = nr.readNext();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    private String getField(String input, String fieldName) {
        String str = fieldName + "=";
        int pos = input.indexOf(str);
        if (pos == -1) {
            return "";
        }
        String tmp = input.substring(pos + str.length());
        if (tmp.endsWith("]")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }
}

