/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.alertMigration;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.helpers.alertMigration.Alert13Parser;

public class MigrationServlet
extends HttpServlet {
    private final Log log = LogFactory.getLog(MigrationServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List fileItemsList = null;
            try {
                fileItemsList = servletFileUpload.parseRequest(req);
            }
            catch (FileUploadException e) {
                PrintWriter writer = resp.getWriter();
                writer.write("<strong>File upload failed: </strong><br/>");
                for (StackTraceElement elem : e.getStackTrace()) {
                    writer.write(elem.toString() + "br/>");
                }
                writer.flush();
                return;
            }
            for (FileItem fileItem : fileItemsList) {
                if (fileItem.isFormField()) continue;
                Alert13Parser parser = new Alert13Parser(fileItem.getInputStream());
                List notifications = parser.parse();
                AlertNotificationManagerLocal notificationManager = LookupUtil.getAlertNotificationManager();
                Subject overlord = LookupUtil.getSubjectManager().getOverlord();
                notificationManager.mergeTransientAlertNotifications(overlord, notifications);
                PrintWriter writer = resp.getWriter();
                writer.write("<strong>Alert Definitions have been migrated</strong><p/>");
                writer.write("<a href=\"/Dashboard.do\">To the RHQ Dashboard</a>");
                writer.flush();
            }
        }
    }
}

