/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.rhq.helpers.perftest.support.Exporter;
import org.rhq.helpers.perftest.support.FileFormat;
import org.rhq.helpers.perftest.support.Importer;
import org.rhq.helpers.perftest.support.Input;
import org.rhq.helpers.perftest.support.Output;
import org.rhq.helpers.perftest.support.Settings;
import org.rhq.helpers.perftest.support.config.Entity;
import org.rhq.helpers.perftest.support.config.ExportConfiguration;
import org.rhq.helpers.perftest.support.jpa.mapping.MappingTranslator;

public class Main {
    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int option;
        LongOpt[] longOptions = new LongOpt[]{new LongOpt("url", 1, null, 114), new LongOpt("user", 1, null, 117), new LongOpt("password", 1, null, 112), new LongOpt("driver-class", 1, null, 100), new LongOpt("config-file", 1, null, 99), new LongOpt("export", 0, null, 101), new LongOpt("import", 0, null, 105), new LongOpt("help", 0, null, 104), new LongOpt("file", 1, null, 102), new LongOpt("format", 1, null, 111)};
        Getopt options = new Getopt("data", args, "eihr:u:p:d:c:f:o:", longOptions);
        String url = null;
        String user = null;
        String password = null;
        String driverClass = null;
        String configFile = null;
        String ioFileName = null;
        String format = "xml";
        boolean doExport = false;
        boolean doImport = false;
        ArrayList<String> entities = new ArrayList<String>();
        while ((option = options.getopt()) != -1) {
            switch (option) {
                case 114: {
                    url = options.getOptarg();
                    break;
                }
                case 117: {
                    user = options.getOptarg();
                    break;
                }
                case 112: {
                    password = options.getOptarg();
                    break;
                }
                case 100: {
                    driverClass = options.getOptarg();
                    break;
                }
                case 99: {
                    configFile = options.getOptarg();
                    break;
                }
                case 101: {
                    doExport = true;
                    break;
                }
                case 105: {
                    doImport = true;
                    break;
                }
                case 104: {
                    Main.usage();
                    break;
                }
                case 102: {
                    ioFileName = options.getOptarg();
                    break;
                }
                case 111: {
                    format = options.getOptarg();
                }
            }
        }
        for (int i = options.getOptind(); i < args.length; ++i) {
            entities.add(args[i]);
        }
        Properties settings = new Properties();
        Main.putNotNull(settings, "url", url);
        Main.putNotNull(settings, "user", user);
        Main.putNotNull(settings, "password", password);
        Main.putNotNull(settings, "driverClass", driverClass);
        if (!Main.validate(settings)) {
            System.exit(1);
        }
        ExportConfiguration config = null;
        if (configFile != null) {
            JAXBContext c = ExportConfiguration.getJAXBContext();
            Unmarshaller um = c.createUnmarshaller();
            config = (ExportConfiguration)um.unmarshal((Reader)new FileReader(configFile));
        }
        if (config == null) {
            config = new ExportConfiguration();
            for (String entity : entities) {
                Entity e = new Entity();
                e.setName(entity);
                e.setIncludeAllFields(true);
                e.setFilter("SELECT * FROM " + MappingTranslator.getTableName(config.getClassForEntity(e)));
                config.getEntities().add(e);
            }
        }
        config.setSettings(settings);
        if (doExport) {
            Output output = Settings.getOutputObject(format, ioFileName);
            try {
                Exporter.run(config, output.getConsumer());
            }
            finally {
                output.close();
            }
        } else if (doImport) {
            Input input = Settings.getInputObject(format, ioFileName);
            try {
                Importer.run(settings, input);
            }
            finally {
                input.close();
            }
        } else {
            System.err.println("You must specify whether to export or import.");
            System.exit(1);
        }
        System.exit(0);
    }

    private static void putNotNull(Properties settings, String key, String value) {
        if (value != null) {
            settings.put(key, value);
        }
    }

    private static boolean validate(Properties settings) {
        boolean ok = true;
        if (!settings.containsKey("url")) {
            System.err.println("The url of the database to connect to is missing.");
            ok = false;
        }
        return ok;
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("data(.sh|.bat) (--export|--import) [<other-options>] [entity-names...]");
        System.out.println();
        System.out.println("--url : the JDBC URL to the database");
        System.out.println("--username : the database username");
        System.out.println("--password : the database password");
        System.out.println("--driver-class : the full name of the JDBC driver class");
        System.out.println("--config-file : The configuration file specifying what entities to export");
        System.out.println("--file : the file to export the data to or to import the data from (defaults to standard output or input respectively)");
        System.out.println("--format : one of " + Arrays.asList(FileFormat.values()));
        System.out.println("--help : this info");
        System.exit(0);
    }
}

