/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.reporting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.rhq.helpers.perftest.support.reporting.PerformanceReportExporter;
import org.rhq.helpers.perftest.support.testng.PerformanceReporting;
import org.testng.ITestResult;

public class ExcelExporter
implements PerformanceReportExporter {
    private static final String DOT_XLS = ".xls";
    static final String TARGET = "target/";
    String baseFileName;
    PerformanceReporting.Rolling rolling;
    CellStyle integerStyle;
    CellStyle boldText;

    @Override
    public void setBaseFile(String fileName) {
        this.baseFileName = fileName;
        if (this.baseFileName.startsWith(TARGET)) {
            this.baseFileName = TARGET + this.baseFileName;
        }
    }

    @Override
    public void setRolling(PerformanceReporting.Rolling rolling) {
        this.rolling = rolling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Map<String, Long> timings, ITestResult result) {
        HSSFWorkbook wb;
        FileInputStream inp = null;
        String fileName = this.getFileName();
        try {
            inp = new FileInputStream(fileName);
            wb = new HSSFWorkbook((InputStream)inp);
        }
        catch (Exception e) {
            wb = new HSSFWorkbook();
        }
        finally {
            if (inp != null) {
                try {
                    ((InputStream)inp).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        FileOutputStream fileOut = null;
        try {
            if (wb.getNumberOfSheets() == 0) {
                wb.createSheet("Overview");
            }
            Sheet sheet = wb.getSheetAt(0);
            DataFormat df = wb.createDataFormat();
            this.integerStyle = wb.createCellStyle();
            this.integerStyle.setDataFormat(df.getFormat("#######0"));
            Font boldFont = wb.createFont();
            boldFont.setBoldweight((short)700);
            this.boldText = wb.createCellStyle();
            this.boldText.setFont(boldFont);
            this.createOverviewHeaderIfNeeded(sheet);
            long time = this.getTotalTime(timings);
            this.createOverviewEntry(sheet, time, result);
            this.createDetailsSheet((Workbook)wb, timings, result);
            File outFile = new File(fileName);
            System.out.println("ExcelExporter, writing to " + outFile.getAbsolutePath());
            fileOut = new FileOutputStream(outFile);
            wb.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to close the workbook: " + e.getMessage());
            }
        }
    }

    private void createDetailsSheet(Workbook wb, Map<String, Long> timings, ITestResult result) {
        Sheet sheet;
        String name = result.getTestClass().getName();
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        if ((sheet = wb.getSheet(name = name + "." + result.getName())) == null) {
            sheet = wb.createSheet(name);
        }
        Row row = this.appendRow(sheet);
        Cell cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Class");
        name = result.getTestClass().getName();
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        row.createCell(1).setCellValue(name);
        row = this.appendRow(sheet);
        cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Method");
        row.createCell(1).setCellValue(result.getName());
        cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Success:");
        row.createCell(1).setCellValue(result.isSuccess());
        row = this.appendRow(sheet);
        cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("TestNG timing");
        row.createCell(1).setCellValue((double)(result.getEndMillis() - result.getStartMillis()));
        row = this.appendRow(sheet);
        cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Perf test timing");
        row.createCell(1).setCellValue((double)this.getTotalTime(timings));
        row = this.appendRow(sheet);
        row = this.appendRow(sheet);
        cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Individual Timings");
        row = this.appendRow(sheet);
        cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Name");
        cell = row.createCell(1);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Duration");
        Set<Map.Entry<String, Long>> data = timings.entrySet();
        TreeSet<Map.Entry<String, Long>> sorted = new TreeSet<Map.Entry<String, Long>>(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> item1, Map.Entry<String, Long> item2) {
                return item1.getKey().compareTo(item2.getKey());
            }
        });
        sorted.addAll(data);
        for (Map.Entry entry : sorted) {
            row = this.appendRow(sheet);
            cell = row.createCell(0);
            cell.setCellValue((String)entry.getKey());
            cell = row.createCell(1);
            cell.setCellStyle(this.integerStyle);
            cell.setCellValue((double)((Long)entry.getValue()).longValue());
        }
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
    }

    private void createOverviewEntry(Sheet sheet, long testTime, ITestResult result) {
        Row row = this.appendRow(sheet);
        Cell cell = row.createCell(0);
        cell.setCellType(1);
        String name = result.getTestClass().getName();
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        name = name + "." + result.getName();
        cell.setCellValue(name);
        cell = row.createCell(1);
        cell.setCellType(4);
        cell.setCellValue(result.isSuccess());
        cell = row.createCell(2);
        cell.setCellType(0);
        cell.setCellStyle(this.integerStyle);
        cell.setCellValue((double)(result.getEndMillis() - result.getStartMillis()));
        cell = row.createCell(3);
        cell.setCellType(0);
        cell.setCellStyle(this.integerStyle);
        cell.setCellValue((double)testTime);
    }

    private void createOverviewHeaderIfNeeded(Sheet sheet) {
        Row row = sheet.getRow(0);
        if (row == null) {
            row = sheet.createRow(0);
        }
        Cell cell = row.createCell(0);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Name");
        cell = row.createCell(1);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("Success");
        cell = row.createCell(2);
        cell.setCellStyle(this.boldText);
        cell.setCellValue("TestNG timing");
        cell.setCellStyle(this.boldText);
        cell = row.createCell(3);
        cell.setCellValue("Perf timing");
        cell.setCellStyle(this.boldText);
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(2);
        sheet.autoSizeColumn(3);
    }

    private long getTotalTime(Map<String, Long> timings) {
        long summaryTime = 0L;
        for (Map.Entry<String, Long> item : timings.entrySet()) {
            summaryTime += item.getValue().longValue();
        }
        return summaryTime;
    }

    private Row appendRow(Sheet sheet) {
        int lastRow = sheet.getLastRowNum();
        Row ret = sheet.createRow(lastRow + 1);
        return ret;
    }

    private String getFileName() {
        String fileName = this.baseFileName;
        String suffix = "";
        switch (this.rolling) {
            case HOURLY: {
                SimpleDateFormat df = new SimpleDateFormat("yyMMdd-kk");
                suffix = "-" + df.format(new Date());
                break;
            }
            case DAILY: {
                SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
                suffix = "-" + df.format(new Date());
            }
        }
        fileName = fileName + suffix + DOT_XLS;
        return fileName;
    }
}

