/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.rhq.helpers.perftest.support.Input;
import org.rhq.helpers.perftest.support.Output;
import org.rhq.helpers.perftest.support.input.CsvInput;
import org.rhq.helpers.perftest.support.input.FileInputStreamProvider;
import org.rhq.helpers.perftest.support.input.InputStreamProvider;
import org.rhq.helpers.perftest.support.input.SystemInProvider;
import org.rhq.helpers.perftest.support.input.XmlInput;
import org.rhq.helpers.perftest.support.input.ZipInputStreamProviderDecorator;
import org.rhq.helpers.perftest.support.input.ZippedCsvInput;
import org.rhq.helpers.perftest.support.output.CsvOutput;
import org.rhq.helpers.perftest.support.output.XmlOutput;
import org.rhq.helpers.perftest.support.output.ZippedCsvOutput;
import org.rhq.helpers.perftest.support.output.ZippedXmlOutput;

public enum FileFormat {
    XML{

        @Override
        public Input getInput(String inputSpec) throws IOException {
            InputStreamProvider isp = inputSpec == null ? new SystemInProvider() : new FileInputStreamProvider(new File(inputSpec));
            return new XmlInput(isp, inputSpec != null);
        }

        @Override
        public Input getInput(InputStreamProvider provider) throws IOException {
            return new XmlInput(provider, true);
        }

        @Override
        public Output getOutput(String outputSpec) throws IOException {
            OutputStream stream = outputSpec == null ? System.out : new FileOutputStream(outputSpec);
            return new XmlOutput(stream, outputSpec != null);
        }
    }
    ,
    CSV{

        @Override
        public Input getInput(String inputSpec) throws IOException {
            File directory = new File(inputSpec);
            return new CsvInput(directory);
        }

        @Override
        public Input getInput(InputStreamProvider provider) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Output getOutput(String outputSpec) throws IOException {
            File directory = new File(outputSpec);
            return new CsvOutput(directory);
        }
    }
    ,
    ZIPPED_XML{

        @Override
        public Input getInput(String inputSpec) throws IOException {
            InputStreamProvider isp = inputSpec == null ? new SystemInProvider() : new FileInputStreamProvider(new File(inputSpec));
            return new XmlInput(new ZipInputStreamProviderDecorator(isp, true), inputSpec != null);
        }

        @Override
        public Input getInput(InputStreamProvider provider) {
            return new XmlInput(new ZipInputStreamProviderDecorator(provider, true), true);
        }

        @Override
        public Output getOutput(String outputSpec) throws IOException {
            OutputStream stream = outputSpec == null ? System.out : new FileOutputStream(outputSpec);
            return new ZippedXmlOutput(stream, outputSpec != null);
        }
    }
    ,
    ZIPPED_CSV{

        @Override
        public Input getInput(String inputSpec) throws IOException {
            File file = new File(inputSpec);
            return new ZippedCsvInput(new ZipInputStreamProviderDecorator(new FileInputStreamProvider(file), false));
        }

        @Override
        public Input getInput(InputStreamProvider provider) throws IOException {
            if (provider instanceof ZipInputStreamProviderDecorator) {
                return new ZippedCsvInput((ZipInputStreamProviderDecorator)provider);
            }
            return new ZippedCsvInput(new ZipInputStreamProviderDecorator(provider, false));
        }

        @Override
        public Output getOutput(String outputSpec) throws IOException {
            File file = new File(outputSpec);
            return new ZippedCsvOutput(file);
        }
    };


    public abstract Input getInput(String var1) throws IOException;

    public abstract Input getInput(InputStreamProvider var1) throws IOException;

    public abstract Output getOutput(String var1) throws IOException;
}

