/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.input;

import java.io.File;
import java.io.IOException;
import org.dbunit.dataset.csv.CsvProducer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.rhq.helpers.perftest.support.Input;

public class CsvInput
implements Input {
    private File directory;
    private CsvProducer producer;

    public CsvInput(File directory) {
        this.directory = directory;
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected CsvProducer getCsvProducer() {
        return this.producer;
    }

    @Override
    public IDataSetProducer getProducer() throws Exception {
        if (this.producer == null) {
            if (!this.directory.isDirectory()) {
                throw new IllegalArgumentException("'" + this.directory.getAbsolutePath() + "' must be a directory for CSV type input.");
            }
            this.producer = new CsvProducer(this.directory);
        }
        return this.producer;
    }

    @Override
    public void close() throws IOException {
        this.producer = null;
    }
}

