/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.jpa;

import java.lang.reflect.Field;
import org.rhq.helpers.perftest.support.config.Entity;
import org.rhq.helpers.perftest.support.config.ExportConfiguration;
import org.rhq.helpers.perftest.support.config.Relationship;
import org.rhq.helpers.perftest.support.jpa.DependencyInclusionResolver;
import org.rhq.helpers.perftest.support.jpa.Edge;

public class ConfigurableDependencyInclusionResolver
implements DependencyInclusionResolver {
    private ExportConfiguration edg;

    public ConfigurableDependencyInclusionResolver(ExportConfiguration edg) {
        this.edg = edg;
    }

    @Override
    public boolean isValid(Edge edge) {
        Entity from = this.edg.getEntity(edge.getFrom().getEntity());
        Entity to = this.edg.getEntity(edge.getTo().getEntity());
        if (this.edg.isIncludeExplicitDependentsImplicitly() && edge.getFromField() != null && from == null) {
            return true;
        }
        if (from != null) {
            return this.isValid(from, edge.getFromField());
        }
        if (to != null) {
            return this.isValid(to, edge.getToField());
        }
        return false;
    }

    private boolean isValid(Entity entity, Field field) {
        if (field == null) {
            return false;
        }
        for (Relationship relationship : entity.getRelationships()) {
            String fieldName = relationship.getField();
            if (!field.getName().equals(fieldName)) continue;
            return !relationship.isExclude();
        }
        return entity.isIncludeAllFields();
    }
}

