/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.rhq.helpers.perftest.support.config.Entity;
import org.rhq.helpers.perftest.support.config.ExportConfiguration;
import org.rhq.helpers.perftest.support.dbunit.DbUnitUtil;
import org.rhq.helpers.perftest.support.dbunit.EntityRelationshipFilter;
import org.rhq.helpers.perftest.support.jpa.ColumnValues;
import org.rhq.helpers.perftest.support.jpa.ConfigurableDependencyInclusionResolver;
import org.rhq.helpers.perftest.support.jpa.mapping.MappingTranslator;

public class Exporter {
    private Exporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(ExportConfiguration config, IDataSetConsumer consumer) throws Exception {
        IDatabaseConnection connection = DbUnitUtil.getConnection(config.getSettings());
        try {
            Map<Entity, String> entityQueries = Exporter.getEntityQueries(config);
            HashMap pksToLoad = new HashMap();
            for (Map.Entry<Entity, String> entry : entityQueries.entrySet()) {
                Entity entity = entry.getKey();
                String query = entry.getValue();
                String tableName = MappingTranslator.getTableName(config.getClassForEntity(entity));
                Set<ColumnValues> pks = Exporter.getPksFromQuery(connection, tableName, query);
                pksToLoad.put(config.getClassForEntity(entity), pks);
            }
            IDataSet data = null;
            if (pksToLoad.isEmpty()) {
                data = connection.createDataSet();
            } else {
                EntityRelationshipFilter filter = new EntityRelationshipFilter(connection, pksToLoad, new ConfigurableDependencyInclusionResolver(config));
                data = new FilteredDataSet((ITableFilter)filter, connection.createDataSet());
            }
            ReplacementDataSet nullReplacingData = new ReplacementDataSet(data);
            nullReplacingData.addReplacementObject(null, (Object)"%NULL%");
            DataSetProducerAdapter producer = new DataSetProducerAdapter((IDataSet)nullReplacingData);
            producer.setConsumer(consumer);
            producer.produce();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ColumnValues> getPksFromQuery(IDatabaseConnection connection, String table, String query) throws DataSetException, SQLException {
        HashSet<ColumnValues> ret = new HashSet<ColumnValues>();
        IDataSet data = connection.createDataSet(new String[]{table});
        Column[] tablePks = data.getTableMetaData(table).getPrimaryKeys();
        String pkName = tablePks[0].getColumnName();
        if (query == null) {
            query = "SELECT " + pkName + " FROM " + table;
        }
        Connection jdbcConnection = connection.getConnection();
        Statement statement = null;
        ResultSet results = null;
        try {
            statement = jdbcConnection.createStatement();
            results = statement.executeQuery(query);
            while (results.next()) {
                ColumnValues pks = new ColumnValues();
                for (Column pk : tablePks) {
                    Object pkVal = results.getObject(pkName);
                    pks.add(pk.getColumnName(), pkVal);
                }
                ret.add(pks);
            }
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private static Map<Entity, String> getEntityQueries(ExportConfiguration config) {
        HashMap<Entity, String> ret = new HashMap<Entity, String>();
        for (Entity e : config.getEntities()) {
            if (!e.isRoot()) continue;
            ret.put(e, e.getFilter());
        }
        return ret;
    }
}

