/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.dbsetup;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.rhq.core.db.ant.dbupgrade.DBUpgrader;
import org.rhq.core.db.setup.DBSetup;

public class DbSetup {
    private static final String MINIMAL_VERSION_OF_DATA = "db-data-combined.2.94.xml";
    private static final String MINIMAL_VERSION_OF_SCHEMA = "db-schema-combined.2.94.xml";
    private static final Map<String, String> REPLACEMENTS = new HashMap<String, String>();
    private Connection connection;

    public DbSetup(Connection connection) throws Exception {
        this.connection = connection;
    }

    public void setup(String targetVersion) throws Exception {
        this.setup();
        this.upgrade(targetVersion);
    }

    public void upgrade(String targetVersion) throws Exception {
        Project project = new Project();
        File upgradeFile = DbSetup.getFileFromDbUtils("db-upgrade.xml");
        try {
            project.setCoreLoader(this.getClass().getClassLoader());
            project.init();
            project.setProperty("target.schema.version", targetVersion == null ? "LATEST" : targetVersion);
            DbSetup.loadDbSetupAntTasksProperties(project);
            new ProjectHelper2().parse(project, (Object)upgradeFile);
            Target defaultTarget = (Target)project.getTargets().get(project.getDefaultTarget());
            for (Task t : defaultTarget.getTasks()) {
                DBUpgrader upgrader = null;
                if (t instanceof DBUpgrader) {
                    upgrader = (DBUpgrader)t;
                } else if (t instanceof UnknownElement && "dbupgrade".equals(t.getTaskType())) {
                    UnknownElement u = (UnknownElement)t;
                    u.maybeConfigure();
                    if (u.getTask() instanceof DBUpgrader) {
                        upgrader = (DBUpgrader)u.getTask();
                    }
                }
                if (upgrader == null) continue;
                upgrader.setConnection(this.connection);
                break;
            }
            project.executeTarget(project.getDefaultTarget());
        }
        catch (BuildException e) {
            throw new RuntimeException("Cannot run ANT on script [" + upgradeFile + "]. Cause: " + (Object)((Object)e), e);
        }
        finally {
            upgradeFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() throws Exception {
        DBSetup dbSetup = new DBSetup(this.connection);
        File minimalSchema = DbSetup.getFileFromResource(MINIMAL_VERSION_OF_SCHEMA, this.getClass().getClassLoader());
        File currentSchema = DbSetup.getFileFromDbUtils("db-schema-combined.xml");
        try {
            this.replaceTokensInFile(minimalSchema);
            this.replaceTokensInFile(currentSchema);
            dbSetup.uninstall(currentSchema.getAbsolutePath());
            dbSetup.setup(minimalSchema.getAbsolutePath());
        }
        finally {
            minimalSchema.delete();
            currentSchema.delete();
        }
        File data = DbSetup.getFileFromResource(MINIMAL_VERSION_OF_DATA, this.getClass().getClassLoader());
        try {
            this.replaceTokensInFile(data);
            dbSetup.setup(data.getAbsolutePath(), null, true, false);
        }
        finally {
            data.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceTokensInFile(File f) throws IOException {
        Properties properties = DbSetup.getDbSetupProperties();
        String contents = this.readIntoString(new FileInputStream(f));
        for (Map.Entry<String, String> entry : REPLACEMENTS.entrySet()) {
            String token = entry.getKey();
            String value = properties.getProperty(token);
            if (value == null) continue;
            contents = contents.replaceAll(token, value);
        }
        FileWriter wrt = new FileWriter(f);
        try {
            wrt.write(contents.toCharArray());
        }
        catch (Throwable throwable) {
            DbSetup.safeClose(wrt);
            throw throwable;
        }
        DbSetup.safeClose(wrt);
    }

    private static Properties getDbSetupProperties() throws IOException {
        Properties dbSetupProperties = DbSetup.loadPropertiesFromDbUtils("dbsetup.properties");
        dbSetupProperties.put("project.version", DbSetup.class.getPackage().getImplementationVersion());
        return dbSetupProperties;
    }

    private static void loadDbSetupAntTasksProperties(Project project) throws Exception {
        Properties taskDefs = DbSetup.loadPropertiesFromDbUtils("db-ant-tasks.properties");
        for (Map.Entry<Object, Object> entry : taskDefs.entrySet()) {
            String taskName = (String)entry.getKey();
            String taskClassName = (String)entry.getValue();
            project.addTaskDefinition(taskName, Class.forName(taskClassName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromDbUtils(String resourceName) throws IOException {
        Properties properties;
        InputStream propertiesStream = DBSetup.class.getClassLoader().getResourceAsStream(resourceName);
        try {
            Properties properties2 = new Properties();
            properties2.load(propertiesStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            DbSetup.safeClose(propertiesStream);
            throw throwable;
        }
        DbSetup.safeClose(propertiesStream);
        return properties;
    }

    private static File getFileFromDbUtils(String fileName) throws IOException {
        return DbSetup.getFileFromResource(fileName, DBSetup.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileFromResource(String resourceName, ClassLoader cl) throws IOException {
        File file;
        InputStream stream = cl.getResourceAsStream(resourceName);
        if (stream == null) {
            throw new FileNotFoundException("Could not find " + resourceName + " in the classloader.");
        }
        File tmpFile = File.createTempFile("DbSetup", null);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile));
        try {
            DbSetup.copy(stream, out);
            file = tmpFile;
        }
        catch (Throwable throwable) {
            DbSetup.safeClose(stream, out);
            throw throwable;
        }
        DbSetup.safeClose(stream, out);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readIntoString(InputStream s) throws IOException {
        char[] buffer = new char[32768];
        StringBuilder bld = new StringBuilder();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(s));
        try {
            int cnt = 0;
            while ((cnt = rdr.read(buffer, 0, buffer.length)) != -1) {
                bld.append(buffer, 0, cnt);
            }
            String string = bld.toString();
            return string;
        }
        finally {
            rdr.close();
        }
    }

    private static void copy(InputStream source, OutputStream target) throws IOException {
        byte[] buffer = new byte[32768];
        int cnt = 0;
        while ((cnt = source.read(buffer, 0, buffer.length)) != -1) {
            target.write(buffer, 0, cnt);
        }
        target.flush();
    }

    private static void safeClose(Closeable ... streams) {
        for (Closeable stream : streams) {
            try {
                if (stream == null) continue;
                stream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    static {
        REPLACEMENTS.put("@@@SERVER_VERSION@@@", "project.version");
        REPLACEMENTS.put("@@@DB_SCHEMA_VERSION@@@", "db.schema.version");
        REPLACEMENTS.put("@@@ADMINUSERNAME@@@", "server.admin.username");
        REPLACEMENTS.put("@@@ADMINPASSWORD@@@", "server.admin.password.encrypted");
        REPLACEMENTS.put("@@@ADMINEMAIL@@@", "server.admin.email");
        REPLACEMENTS.put("@@@BASEURL@@@", "server.webapp.baseurl");
        REPLACEMENTS.put("@@@JAASPROVIDER@@@", "server.jaas.provider");
        REPLACEMENTS.put("@@@LDAPURL@@@", "server.ldap.url");
        REPLACEMENTS.put("@@@LDAPPROTOCOL@@@", "server.ldap.protocol");
        REPLACEMENTS.put("@@@LDAPLOGINPROP@@@", "server.ldap.loginProperty");
        REPLACEMENTS.put("@@@LDAPBASEDN@@@", "server.ldap.baseDN");
        REPLACEMENTS.put("@@@LDAPSEARCHFILTER@@@", "server.ldap.searchFilter");
        REPLACEMENTS.put("@@@LDAPBINDDN@@@", "server.ldap.bindDN");
        REPLACEMENTS.put("@@@LDAPBINDPW@@@", "server.ldap.bindPW");
        REPLACEMENTS.put("@@@MULTICAST_ADDR@@@", "server.highavail.address");
        REPLACEMENTS.put("@@@MULTICAST_PORT@@@", "server.highavail.port");
    }
}

