/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.jpa;

import java.lang.reflect.Field;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.rhq.helpers.perftest.support.jpa.DependencyInclusionResolver;
import org.rhq.helpers.perftest.support.jpa.Edge;

public class EagerMappingInclusionResolver
implements DependencyInclusionResolver {
    @Override
    public boolean isValid(Edge edge) {
        switch (edge.getDependencyType()) {
            case ONE_TO_ONE: {
                return this.analyzeOneToOne(edge);
            }
            case ONE_TO_MANY: {
                return this.analyzeOneToMany(edge);
            }
            case MANY_TO_MANY: {
                return this.analyzeManyToMany(edge);
            }
        }
        return true;
    }

    private boolean analyzeOneToOne(Edge edge) {
        return edge.getFromField().getAnnotation(OneToOne.class).fetch() == FetchType.EAGER;
    }

    private boolean analyzeOneToMany(Edge edge) {
        Field fromField = edge.getFromField();
        return fromField != null && fromField.getAnnotation(OneToMany.class).fetch() == FetchType.EAGER;
    }

    private boolean analyzeManyToMany(Edge edge) {
        Field fromField = edge.getFromField();
        Field toField = edge.getToField();
        ManyToMany fromAnnotation = fromField.getAnnotation(ManyToMany.class);
        ManyToMany toAnnotation = toField.getAnnotation(ManyToMany.class);
        return fromAnnotation != null && fromAnnotation.fetch() == FetchType.EAGER || toAnnotation != null && fromAnnotation.fetch() == FetchType.EAGER;
    }
}

