/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.testng;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSourceConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.rhq.helpers.perftest.support.FileFormat;
import org.rhq.helpers.perftest.support.Importer;
import org.rhq.helpers.perftest.support.Input;
import org.rhq.helpers.perftest.support.dbsetup.DbSetup;
import org.rhq.helpers.perftest.support.input.FileInputStreamProvider;
import org.rhq.helpers.perftest.support.input.InputStreamProvider;
import org.rhq.helpers.perftest.support.testng.DatabaseState;
import org.rhq.helpers.perftest.support.testng.DatabaseStateStorage;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;

public class DatabaseSetupInterceptor
implements IInvokedMethodListener {
    private static final Log LOG = LogFactory.getLog(DatabaseSetupInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        DatabaseState state = DatabaseSetupInterceptor.getRequiredDatabaseState(method);
        if (state == null) {
            return;
        }
        String dbUrl = "-unknown-";
        Connection jdbcConnection = null;
        Statement statement = null;
        try {
            InputStreamProvider streamProvider = DatabaseSetupInterceptor.getInputStreamProvider(state.url(), state.storage(), method);
            DatabaseDataSourceConnection connection = new DatabaseDataSourceConnection(new InitialContext(), "java:jboss/datasources/RHQDS");
            jdbcConnection = connection.getConnection();
            dbUrl = jdbcConnection.getMetaData().getURL();
            System.out.println("Using database at " + dbUrl);
            System.out.flush();
            this.setDatabaseType((IDatabaseConnection)connection);
            try {
                statement = jdbcConnection.createStatement();
                statement.execute("DROP TABLE RHQ_SUBJECT CASCADE");
            }
            catch (SQLException e) {
                System.out.println("Don't worry about : " + e.getMessage());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            try {
                statement = jdbcConnection.createStatement();
                statement.execute("DROP TABLE RHQ_CONFIG CASCADE");
            }
            catch (SQLException e) {
                System.out.println("Don't worry about : " + e.getMessage());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            System.out.flush();
            FileFormat format = state.format();
            Input input = format.getInput(streamProvider);
            try {
                DbSetup dbSetup = new DbSetup(jdbcConnection);
                dbSetup.setup(state.dbVersion());
                Importer.run((IDatabaseConnection)connection, input);
                dbSetup.upgrade(null);
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to setup a database at [ " + dbUrl + "] for method '" + method.getTestMethod().getMethodName() + "'."), (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Failed to close a statement: " + e.getMessage()));
                }
            }
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Failed to close a JDBC connetion: " + e.getMessage()));
                }
            }
        }
        System.out.flush();
        System.err.flush();
    }

    private void setDatabaseType(IDatabaseConnection connection) throws SQLException {
        DatabaseConfig config = connection.getConfig();
        String name = connection.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
        int major = connection.getConnection().getMetaData().getDatabaseMajorVersion();
        Object type = null;
        if (name.contains("postgres")) {
            type = new PostgresqlDataTypeFactory();
        } else if (name.contains("oracle")) {
            type = major >= 10 ? new Oracle10DataTypeFactory() : new OracleDataTypeFactory();
        }
        if (type != null) {
            LOG.info((Object)("setting db type for dbunit to " + type.getClass().getCanonicalName()));
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        DatabaseState state = DatabaseSetupInterceptor.getRequiredDatabaseState(method);
        if (state == null) {
            return;
        }
        Connection jdbcConnection = null;
        Statement statement = null;
        try {
            DatabaseDataSourceConnection connection = new DatabaseDataSourceConnection(new InitialContext(), "java:jboss/datasources/RHQDS");
            jdbcConnection = connection.getConnection();
            statement = jdbcConnection.createStatement();
            statement.execute("DROP TABLE RHQ_SUBJECT CASCADE");
        }
        catch (Exception e) {
            System.err.println("== drop subject table failed: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Failed to close a statement: " + e.getMessage()));
                }
            }
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Failed to close a JDBC connection: " + e.getMessage()));
                }
            }
        }
    }

    private static DatabaseState getRequiredDatabaseState(IInvokedMethod method) {
        Method javaMethod = method.getTestMethod().getMethod();
        DatabaseState annotation = javaMethod.getAnnotation(DatabaseState.class);
        if (annotation == null) {
            Annotation[] annots;
            boolean skip = false;
            for (Annotation an : annots = javaMethod.getAnnotations()) {
                if (!an.annotationType().equals(BeforeMethod.class) && !an.annotationType().equals(AfterMethod.class) && !an.annotationType().equals(BeforeSuite.class) && !an.annotationType().equals(AfterSuite.class) && !an.annotationType().equals(BeforeTest.class) && !an.annotationType().equals(AfterTest.class)) continue;
                skip = true;
            }
            if (!skip) {
                annotation = javaMethod.getDeclaringClass().getAnnotation(DatabaseState.class);
            }
        }
        return annotation;
    }

    private static InputStreamProvider getInputStreamProvider(final String url, DatabaseStateStorage storage, final IInvokedMethod method) throws FileNotFoundException {
        switch (storage) {
            case CLASSLOADER: {
                return new InputStreamProvider(){

                    @Override
                    public InputStream createInputStream() throws IOException {
                        ClassLoader cl = method.getTestMethod().getMethod().getDeclaringClass().getClassLoader();
                        return cl.getResourceAsStream(url);
                    }
                };
            }
            case FILESYSTEM: {
                return new FileInputStreamProvider(new File(url));
            }
        }
        return null;
    }
}

