/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.dbunit;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.rhq.helpers.perftest.support.dbunit.EntityRelationshipTableIterator;
import org.rhq.helpers.perftest.support.jpa.ColumnValues;
import org.rhq.helpers.perftest.support.jpa.DependencyInclusionResolver;
import org.rhq.helpers.perftest.support.jpa.DependencyType;
import org.rhq.helpers.perftest.support.jpa.Edge;
import org.rhq.helpers.perftest.support.jpa.EntityDependencyGraph;
import org.rhq.helpers.perftest.support.jpa.Node;
import org.rhq.helpers.perftest.support.jpa.mapping.ColumnValuesTableMap;
import org.rhq.helpers.perftest.support.jpa.mapping.EntityTranslation;
import org.rhq.helpers.perftest.support.jpa.mapping.RelationshipTranslation;

public class EntityRelationshipFilter
extends DatabaseSequenceFilter {
    private ColumnValuesTableMap resolvedPks = RESOLUTION_IN_CONSTRUCTOR.get();
    private static final ThreadLocal<ColumnValuesTableMap> RESOLUTION_IN_CONSTRUCTOR = new ThreadLocal();

    public EntityRelationshipFilter(IDatabaseConnection connection, Map<Class<?>, Set<ColumnValues>> allowedPks, DependencyInclusionResolver inclusionResolver) throws DataSetException, SQLException {
        super(connection, EntityRelationshipFilter.getNeccesaryTablesAndSetResolution(connection, inclusionResolver, allowedPks));
        RESOLUTION_IN_CONSTRUCTOR.set(null);
    }

    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        return new EntityRelationshipTableIterator(super.iterator(dataSet, reversed), this.resolvedPks);
    }

    private static String[] getNeccesaryTablesAndSetResolution(IDatabaseConnection connection, DependencyInclusionResolver inclusionResolver, Map<Class<?>, Set<ColumnValues>> primaryPks) throws SQLException {
        ColumnValuesTableMap resolution = EntityRelationshipFilter.resolve(connection, inclusionResolver, primaryPks);
        RESOLUTION_IN_CONSTRUCTOR.set(resolution);
        HashSet<String> tables = new HashSet<String>();
        for (String t : resolution.keySet()) {
            tables.add(t.toLowerCase());
        }
        return tables.toArray(new String[tables.size()]);
    }

    private static ColumnValuesTableMap resolve(IDatabaseConnection connection, DependencyInclusionResolver inclusionResolver, Map<Class<?>, Set<ColumnValues>> primaryPks) throws SQLException {
        ColumnValuesTableMap resolution = new ColumnValuesTableMap();
        EntityDependencyGraph edg = new EntityDependencyGraph();
        edg.addEntities(primaryPks.keySet());
        EntityRelationshipFilter.resolvePks(connection, edg, inclusionResolver, primaryPks, resolution);
        return resolution;
    }

    private static void resolvePks(IDatabaseConnection connection, EntityDependencyGraph edg, DependencyInclusionResolver inclusionResolver, Map<Class<?>, Set<ColumnValues>> primaryPks, ColumnValuesTableMap resolvedPks) throws SQLException {
        for (Map.Entry<Class<?>, Set<ColumnValues>> entry : primaryPks.entrySet()) {
            Node node = edg.getNode(entry.getKey());
            Set<ColumnValues> pks = entry.getValue();
            if (pks != null) {
                for (ColumnValues pk : pks) {
                    int idx = 0;
                    for (ColumnValues.Column col : pk) {
                        if (col.getName() == null) {
                            col.setName(node.getTranslation().getPkColumns()[idx]);
                        }
                        ++idx;
                    }
                }
            }
            EntityRelationshipFilter.resolvePks(connection, inclusionResolver, node, pks, resolvedPks);
        }
    }

    private static void resolvePks(IDatabaseConnection connection, DependencyInclusionResolver inclusionResolver, Node node, Set<ColumnValues> nodePks, ColumnValuesTableMap resolvedPks) throws SQLException {
        Set<ColumnValues> unresolvedPks;
        Set resolvedTablePks = (Set)resolvedPks.get(node.getTranslation().getTableName());
        if (resolvedPks.containsKey(node.getTranslation().getTableName())) {
            if (resolvedTablePks == null) {
                return;
            }
            if (nodePks == null) {
                return;
            }
        }
        if (resolvedTablePks == null || resolvedTablePks.isEmpty()) {
            unresolvedPks = nodePks;
        } else {
            unresolvedPks = new LinkedHashSet<ColumnValues>();
            for (ColumnValues pk : nodePks) {
                if (resolvedTablePks.contains(pk)) continue;
                unresolvedPks.add(pk);
            }
        }
        if (unresolvedPks != null) {
            if (unresolvedPks.isEmpty()) {
                return;
            }
        } else {
            resolvedPks.put(node.getTranslation().getTableName(), null);
        }
        for (Edge e : node.getIncomingEdges()) {
            if (e.getToField() != null) {
                Set<ColumnValues> dependingPks = EntityRelationshipFilter.resolveDependingPks(connection, e, unresolvedPks, resolvedPks);
                EntityRelationshipFilter.resolvePks(connection, inclusionResolver, e.getFrom(), dependingPks, resolvedPks);
                continue;
            }
            resolvedPks.getOrCreate(e.getFrom().getTranslation().getTableName());
        }
        if (unresolvedPks != null) {
            resolvedPks.getOrCreate(node.getTranslation().getTableName()).addAll(unresolvedPks);
        }
        for (Edge e : node.getOutgoingEdges()) {
            if (e.getFromField() != null && inclusionResolver.isValid(e)) {
                Set<ColumnValues> dependentPks = EntityRelationshipFilter.resolveDependentPks(connection, e, unresolvedPks, resolvedPks);
                EntityRelationshipFilter.resolvePks(connection, inclusionResolver, e.getTo(), dependentPks, resolvedPks);
                continue;
            }
            resolvedPks.getOrCreate(e.getTo().getTranslation().getTableName());
        }
    }

    private static Set<ColumnValues> resolveDependentPks(IDatabaseConnection connection, Edge edge, Set<ColumnValues> fromPks, ColumnValuesTableMap resolvedPks) throws SQLException {
        RelationshipTranslation translation = edge.getTranslation();
        if (translation.getRelationTable() != null) {
            HashSet<ColumnValues> columnValues = null;
            if (fromPks != null) {
                columnValues = new HashSet<ColumnValues>();
                for (ColumnValues pk : fromPks) {
                    columnValues.add(pk.clone());
                }
                for (int i = 0; i < translation.getRelationTableFromColumns().length; ++i) {
                    for (ColumnValues cols : columnValues) {
                        cols.getColumns().get(i).setName(translation.getRelationTableFromColumns()[i]);
                    }
                }
            }
            String[] fromAndToCols = new String[translation.getRelationTableFromColumns().length + translation.getRelationTableToColumns().length];
            System.arraycopy(translation.getRelationTableFromColumns(), 0, fromAndToCols, 0, translation.getRelationTableFromColumns().length);
            System.arraycopy(translation.getRelationTableToColumns(), 0, fromAndToCols, translation.getRelationTableFromColumns().length, translation.getRelationTableToColumns().length);
            if (fromPks != null) {
                Set<ColumnValues> fromAndToValues = EntityRelationshipFilter.getValuesFromTable(connection, translation.getRelationTable(), fromAndToCols, columnValues);
                resolvedPks.getOrCreate(translation.getRelationTable()).addAll(fromAndToValues);
                HashSet<ColumnValues> toPks = new HashSet<ColumnValues>();
                for (ColumnValues cols : fromAndToValues) {
                    ColumnValues toPk = new ColumnValues();
                    for (int i = 0; i < translation.getRelationTableToColumns().length; ++i) {
                        String colName = translation.getRelationTableToColumns()[i];
                        String pkName = edge.getTo().getTranslation().getPkColumns()[i];
                        toPk.add(pkName, cols.getColumnByName(colName).getValue());
                    }
                    toPks.add(toPk);
                }
                return EntityRelationshipFilter.removeValuesWithNullColumn(toPks);
            }
            resolvedPks.put(translation.getRelationTable(), null);
            return null;
        }
        if (fromPks == null) {
            return null;
        }
        Set<ColumnValues> columnValues = EntityRelationshipFilter.getValuesFromTable(connection, edge.getFrom().getTranslation().getTableName(), translation.getFromColumns(), fromPks);
        for (int i = 0; i < translation.getToColumns().length; ++i) {
            for (ColumnValues cols : columnValues) {
                cols.getColumns().get(i).setName(translation.getToColumns()[i]);
            }
        }
        boolean columnsDiffer = false;
        HashSet<String> pkColumns = new HashSet<String>(Arrays.asList(edge.getTo().getTranslation().getPkColumns()));
        for (String col : translation.getToColumns()) {
            if (pkColumns.contains(col)) continue;
            columnsDiffer = true;
            break;
        }
        if (columnsDiffer) {
            columnValues = EntityRelationshipFilter.getValuesFromTable(connection, edge.getTo().getTranslation().getTableName(), edge.getTo().getTranslation().getPkColumns(), EntityRelationshipFilter.removeValuesWithNullColumn(columnValues));
        }
        Set<ColumnValues> ret = EntityRelationshipFilter.getValuesFromTable(connection, edge.getTo().getTranslation().getTableName(), edge.getTo().getTranslation().getPkColumns(), columnValues);
        return EntityRelationshipFilter.removeValuesWithNullColumn(ret);
    }

    private static Set<ColumnValues> resolveDependingPks(IDatabaseConnection connection, Edge edge, Set<ColumnValues> toPks, ColumnValuesTableMap resolvedPks) throws SQLException {
        RelationshipTranslation translation = edge.getTranslation();
        if (translation.getRelationTable() == null) {
            if (toPks == null) {
                return null;
            }
            Set<ColumnValues> columnValues = EntityRelationshipFilter.getValuesFromTable(connection, edge.getTo().getTranslation().getTableName(), translation.getToColumns(), toPks);
            for (int i = 0; i < translation.getFromColumns().length; ++i) {
                for (ColumnValues cols : columnValues) {
                    cols.getColumns().get(i).setName(translation.getFromColumns()[i]);
                }
            }
            EntityTranslation fromTranslation = edge.getFrom().getTranslation();
            boolean columnsDiffer = false;
            HashSet<String> pkColumns = new HashSet<String>(Arrays.asList(fromTranslation.getPkColumns()));
            for (String col : translation.getFromColumns()) {
                if (pkColumns.contains(col)) continue;
                columnsDiffer = true;
                break;
            }
            if (columnsDiffer) {
                columnValues = EntityRelationshipFilter.getValuesFromTable(connection, fromTranslation.getTableName(), fromTranslation.getPkColumns(), EntityRelationshipFilter.removeValuesWithNullColumn(columnValues));
            }
            return EntityRelationshipFilter.removeValuesWithNullColumn(columnValues);
        }
        if (edge.getDependencyType() != DependencyType.MANY_TO_MANY) {
            HashSet<ColumnValues> columnValues = null;
            if (toPks != null) {
                columnValues = new HashSet<ColumnValues>();
                for (ColumnValues pk : toPks) {
                    columnValues.add(pk.clone());
                }
                for (int i = 0; i < translation.getRelationTableToColumns().length; ++i) {
                    for (ColumnValues cols : columnValues) {
                        cols.getColumns().get(i).setName(translation.getRelationTableToColumns()[i]);
                    }
                }
            }
            String[] fromAndToCols = new String[translation.getRelationTableFromColumns().length + translation.getRelationTableToColumns().length];
            System.arraycopy(translation.getRelationTableFromColumns(), 0, fromAndToCols, 0, translation.getRelationTableFromColumns().length);
            System.arraycopy(translation.getRelationTableToColumns(), 0, fromAndToCols, translation.getRelationTableFromColumns().length, translation.getRelationTableToColumns().length);
            if (toPks != null) {
                Set<ColumnValues> fromAndToValues = EntityRelationshipFilter.getValuesFromTable(connection, translation.getRelationTable(), fromAndToCols, columnValues);
                resolvedPks.getOrCreate(translation.getRelationTable()).addAll(fromAndToValues);
                HashSet<ColumnValues> fromPks = new HashSet<ColumnValues>();
                for (ColumnValues cols : fromAndToValues) {
                    ColumnValues fromPk = new ColumnValues();
                    for (int i = 0; i < translation.getRelationTableFromColumns().length; ++i) {
                        String colName = translation.getRelationTableFromColumns()[i];
                        String pkName = edge.getFrom().getTranslation().getPkColumns()[i];
                        fromPk.add(pkName, cols.getColumnByName(colName).getValue());
                    }
                    fromPks.add(fromPk);
                }
                return EntityRelationshipFilter.removeValuesWithNullColumn(fromPks);
            }
            resolvedPks.put(translation.getRelationTable(), null);
            return null;
        }
        return toPks == null ? null : new HashSet();
    }

    private static Set<ColumnValues> removeValuesWithNullColumn(Set<ColumnValues> columnValues) {
        HashSet<ColumnValues> ret = new HashSet<ColumnValues>();
        for (ColumnValues cols : columnValues) {
            boolean add = true;
            for (ColumnValues.Column c : cols) {
                if (c.getValue() != null) continue;
                add = false;
                break;
            }
            if (!add) continue;
            ret.add(cols);
        }
        return ret;
    }

    private static String colNamesToSql(String[] colNames) {
        StringBuilder bld = new StringBuilder();
        if (colNames.length == 0) {
            return "";
        }
        for (String col : colNames) {
            bld.append(", ").append(col);
        }
        return bld.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ColumnValues> getValuesFromTable(IDatabaseConnection connection, String tableName, String[] valueColumns, Set<ColumnValues> knownlColumns) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ").append(EntityRelationshipFilter.colNamesToSql(valueColumns)).append(" FROM ").append(tableName).append(" WHERE ");
        HashSet<ColumnValues> ret = new HashSet<ColumnValues>();
        for (ColumnValues cols : knownlColumns) {
            sql.append("(");
            for (ColumnValues.Column c : cols) {
                sql.append(c.getName()).append(" = ? AND ");
            }
            sql.replace(sql.length() - 5, sql.length(), ") OR ");
        }
        sql.replace(sql.length() - 4, sql.length(), "");
        PreparedStatement st = null;
        try {
            st = connection.getConnection().prepareStatement(sql.toString());
            int idx = 1;
            for (ColumnValues cols : knownlColumns) {
                for (ColumnValues.Column c : cols) {
                    st.setObject(idx++, c.getValue());
                }
            }
            ResultSet rs = st.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                ColumnValues vals = new ColumnValues();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String columnName = rsmd.getColumnName(i);
                    Object value = rs.getObject(i);
                    vals.add(columnName, value);
                }
                ret.add(vals);
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        return ret;
    }
}

